/*
 * Decompiled with CFR 0.152.
 */
package com.portaudio;

import com.portaudio.StreamInfo;

public class BlockingStream {
    private long nativeStream;
    private int inputFormat = -1;
    private int outputFormat = -1;

    protected BlockingStream() {
    }

    public native int getReadAvailable();

    public native int getWriteAvailable();

    private native boolean readFloats(float[] var1, int var2);

    private native boolean writeFloats(float[] var1, int var2);

    public boolean read(float[] buffer, int numFrames) {
        if (this.inputFormat != 1) {
            throw new RuntimeException("Tried to read float samples from a non float stream.");
        }
        return this.readFloats(buffer, numFrames);
    }

    public boolean write(float[] buffer, int numFrames) {
        if (this.outputFormat != 1) {
            throw new RuntimeException("Tried to write float samples to a non float stream.");
        }
        return this.writeFloats(buffer, numFrames);
    }

    private native boolean readShorts(short[] var1, int var2);

    private native boolean writeShorts(short[] var1, int var2);

    public boolean read(short[] buffer, int numFrames) {
        if (this.inputFormat != 8) {
            throw new RuntimeException("Tried to read short samples from a non short stream.");
        }
        return this.readShorts(buffer, numFrames);
    }

    public boolean write(short[] buffer, int numFrames) {
        if (this.outputFormat != 8) {
            throw new RuntimeException("Tried to write short samples from a non short stream.");
        }
        return this.writeShorts(buffer, numFrames);
    }

    public native void start();

    public native void stop();

    public native void abort();

    public native void close();

    public native boolean isStopped();

    public native boolean isActive();

    public String toString() {
        return "BlockingStream: streamPtr = " + Long.toHexString(this.nativeStream) + ", inFormat = " + this.inputFormat + ", outFormat = " + this.outputFormat;
    }

    public native double getTime();

    private native void getInfo(StreamInfo var1);

    public StreamInfo getInfo() {
        StreamInfo streamInfo = new StreamInfo();
        this.getInfo(streamInfo);
        return streamInfo;
    }
}

