/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.PanUnit;
import com.softsynth.jsyn.SawtoothOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.view102.PortFader;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;

public class TJ_SawLoops
extends Applet {
    SawtoothOscillator myOsc;
    LineOut myOut;
    TriangleOscillator myLFO;
    AddUnit mySum;
    ExponentialLag myLag;
    PanUnit myPanner;
    Button ping;

    public static void main(String[] args) {
        TJ_SawLoops applet = new TJ_SawLoops();
        AppletFrame frame = new AppletFrame("Test Java Synthesis", applet);
        frame.resize(600, 300);
        frame.show();
        int i = 0;
        while (i < 20) {
            applet.start();
            System.out.println("Loop " + i);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                System.err.println(" Caught " + e);
            }
            applet.stop();
            ++i;
        }
        System.exit(1);
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.myOsc = new SawtoothOscillator();
            this.myLFO = new TriangleOscillator();
            this.mySum = new AddUnit();
            this.myLag = new ExponentialLag();
            this.myPanner = new PanUnit();
            this.myOut = new LineOut();
            this.myLag.output.connect(this.mySum.inputB);
            this.myLFO.output.connect(this.mySum.inputA);
            this.mySum.output.connect(this.myOsc.frequency);
            this.myOsc.output.connect(this.myPanner.input);
            this.myPanner.output.connect(0, this.myOut.input, 0);
            this.myPanner.output.connect(1, this.myOut.input, 1);
            this.myLag.input.setSignalType(2);
            this.myLag.current.setSignalType(2);
            this.myLFO.amplitude.setSignalType(2);
            this.add(new PortFader(this.myOsc.amplitude, 0.5, 0.0, 0.999));
            this.add(new PortFader(this.myLFO.frequency, "ModRate", 0.2, 0.0, 20.0));
            this.add(new PortFader(this.myLFO.amplitude, "ModDepth", 400.0, 0.0, 2000.0));
            this.add(new PortFader(this.myLag.input, "CenterFreq", 200.0, 0.0, 2000.0));
            this.add(new PortFader(this.myPanner.pan, 0.0, -1.0, 1.0));
            this.add(new PortFader(this.myLag.halfLife, 0.1, 0.0, 1.0));
            this.ping = new Button("Ping");
            this.add(this.ping);
            this.myOut.start();
            this.myOsc.start();
            this.mySum.start();
            this.myLag.start();
            this.myPanner.start();
            this.myLFO.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.myOsc.delete();
            this.myOut.delete();
            this.myLFO.delete();
            this.mySum.delete();
            this.myLag.delete();
            this.myOsc = null;
            this.myOut = null;
            this.myLFO = null;
            this.mySum = null;
            this.myLag = null;
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        try {
            if (evt.target == this.ping) {
                this.myLag.current.set(2000.0);
                return true;
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
            return true;
        }
        return false;
    }
}

