/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.util.SampleQueueOutputStream;

public class TestOutputStream {
    SampleReader_16V1 mySampler;
    LineOut myOut;
    static final int FRAMES_PER_BLOCK = 8000;
    static final int FRAMES_IN_BUFFER = 65536;
    static final int SAMPLES_PER_BLOCK = 8000;
    short[] data = new short[8000];
    double phaseIncr = 0.02;
    double phase = 0.0;
    double freqScalar = 1.01;
    SampleQueueOutputStream outStream;

    public static void main(String[] args) {
        TestOutputStream app = new TestOutputStream();
        app.test();
    }

    void test() {
        this.initSynth();
        this.testRate(Synth.getFrameRate() * 0.3);
        this.testRate(Synth.getFrameRate() * 1.9);
        this.testRate(Synth.getFrameRate());
        this.testRate(Synth.getFrameRate() * 0.5);
        this.termSynth();
    }

    public void initSynth() {
        try {
            Synth.requestVersion(140);
            Synth.startEngine(0);
            this.mySampler = new SampleReader_16V1();
            this.myOut = new LineOut();
            this.outStream = new SampleQueueOutputStream(this.mySampler.samplePort, 65536, 1);
            this.mySampler.output.connect(0, this.myOut.input, 0);
            this.myOut.start();
        }
        catch (SynthException e) {
            System.err.println("Caught " + e);
        }
    }

    void sendBuffer(int numFrames) {
        int i = 0;
        while (i < numFrames) {
            double tri = this.phase > 0.0 ? 1.0 - 2.0 * this.phase : 1.0 + 2.0 * this.phase;
            this.data[i] = (short)(tri * 32767.0);
            this.phase += this.phaseIncr;
            if (this.phase > 1.0) {
                this.phase -= 2.0;
            }
            if ((i & 0x3F) == 0) {
                this.phaseIncr *= this.freqScalar;
                double SCALAR = 0.999;
                if (this.phaseIncr > 0.02) {
                    this.freqScalar = 0.999;
                } else if (this.phaseIncr < 0.002) {
                    this.freqScalar = 1.001001001001001;
                }
            }
            ++i;
        }
        this.outStream.write(this.data, 0, numFrames);
    }

    public void termSynth() {
        try {
            this.mySampler.delete();
            this.mySampler = null;
            this.myOut.delete();
            this.myOut = null;
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.err.println("Caught " + e);
        }
    }

    void testRate(double sampleRate) {
        System.out.println("Rate = " + sampleRate + " -------------------------");
        System.out.println("avail = " + this.outStream.available());
        while (this.outStream.available() > 8000) {
            this.sendBuffer(8000);
        }
        System.out.println("avail = " + this.outStream.available());
        int time = Synth.getTickCount() + 4;
        this.mySampler.rate.set(time, sampleRate);
        this.mySampler.start(time);
        this.outStream.start(time);
        int i = 0;
        while (i < 8) {
            System.out.println("avail = " + this.outStream.available());
            this.sendBuffer(8000);
            ++i;
        }
        System.out.println("start flushing!");
        this.outStream.flush();
        System.out.println("avail = " + this.outStream.available());
        System.out.println("flush() done.");
        time = Synth.getTickCount() + 4;
        this.mySampler.stop(time);
        this.outStream.stop(time);
        Synth.sleepForTicks(1000);
    }
}

