/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.javasound.MidiDeviceTools;
import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.midi.MessageParser;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.PowerOfTwo;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.util.VoiceAllocator;
import com.softsynth.shared.time.TimeStamp;
import java.io.IOException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;

public class UseMidiKeyboard {
    private static final int MAX_VOICES = 8;
    private Synthesizer synth;
    private VoiceAllocator allocator;
    private LineOut lineOut;
    private double vibratoRate = 5.0;
    private double vibratoDepth = 0.0;
    private UnitOscillator lfo;
    private PowerOfTwo powerOfTwo;
    private MessageParser messageParser;
    private SubtractiveSynthVoice[] voices;

    public static void main(String[] args) {
        UseMidiKeyboard app = new UseMidiKeyboard();
        try {
            app.test();
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int test() throws MidiUnavailableException, IOException, InterruptedException {
        this.setupSynth();
        this.messageParser = new MyParser();
        int result = 2;
        MidiDevice keyboard = MidiDeviceTools.findKeyboard("usb");
        CustomReceiver receiver = new CustomReceiver();
        if (keyboard != null) {
            keyboard.open();
            keyboard.getTransmitter().setReceiver(receiver);
            System.out.println("Play MIDI keyboard: " + keyboard.getDeviceInfo().getDescription());
            result = 0;
        } else {
            System.out.println("Could not find a keyboard.");
        }
        return result;
    }

    double convertPitchToFrequency(double pitch) {
        double concertA = 440.0;
        return 440.0 * Math.pow(2.0, (pitch - 69.0) * 0.08333333333333333);
    }

    private void setupSynth() {
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.powerOfTwo = new PowerOfTwo();
        this.synth.add(this.powerOfTwo);
        this.lfo = new SineOscillator();
        this.synth.add(this.lfo);
        this.lfo.output.connect(this.powerOfTwo.input);
        this.lfo.amplitude.set(this.vibratoDepth);
        this.lfo.frequency.set(this.vibratoRate);
        this.voices = new SubtractiveSynthVoice[8];
        int i = 0;
        while (i < 8) {
            SubtractiveSynthVoice voice = new SubtractiveSynthVoice();
            this.synth.add(voice);
            this.powerOfTwo.output.connect(voice.pitchModulation);
            voice.getOutput().connect(0, this.lineOut.input, 0);
            voice.getOutput().connect(0, this.lineOut.input, 1);
            this.voices[i] = voice;
            ++i;
        }
        this.allocator = new VoiceAllocator(this.voices);
        this.synth.start();
        this.lineOut.start();
        double timeNow = this.synth.getCurrentTime();
        double time = timeNow + 0.5;
    }

    class CustomReceiver
    implements Receiver {
        CustomReceiver() {
        }

        @Override
        public void close() {
            System.out.print("Closed.");
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            byte[] bytes = message.getMessage();
            UseMidiKeyboard.this.messageParser.parse(bytes);
        }
    }

    class MyParser
    extends MessageParser {
        MyParser() {
        }

        @Override
        public void controlChange(int channel, int index, int value) {
            if (index == 1) {
                UseMidiKeyboard.this.vibratoDepth = 0.1 * (double)value / 128.0;
                ((UseMidiKeyboard)UseMidiKeyboard.this).lfo.amplitude.set(UseMidiKeyboard.this.vibratoDepth);
            } else if (index == 102) {
                double bump = 0.95;
                if (value < 64) {
                    UseMidiKeyboard useMidiKeyboard = UseMidiKeyboard.this;
                    useMidiKeyboard.vibratoRate = useMidiKeyboard.vibratoRate * 0.95;
                } else {
                    UseMidiKeyboard useMidiKeyboard = UseMidiKeyboard.this;
                    useMidiKeyboard.vibratoRate = useMidiKeyboard.vibratoRate * 1.0526315789473684;
                }
                System.out.println("vibratoRate = " + UseMidiKeyboard.this.vibratoRate);
                ((UseMidiKeyboard)UseMidiKeyboard.this).lfo.frequency.set(UseMidiKeyboard.this.vibratoRate);
            }
        }

        @Override
        public void noteOff(int channel, int noteNumber, int velocity) {
            UseMidiKeyboard.this.allocator.noteOff(noteNumber, UseMidiKeyboard.this.synth.createTimeStamp());
        }

        @Override
        public void noteOn(int channel, int noteNumber, int velocity) {
            double frequency = UseMidiKeyboard.this.convertPitchToFrequency(noteNumber);
            double amplitude = (double)velocity / 512.0;
            TimeStamp timeStamp = UseMidiKeyboard.this.synth.createTimeStamp();
            UseMidiKeyboard.this.allocator.noteOn(noteNumber, frequency, amplitude, timeStamp);
        }

        @Override
        public void pitchBend(int channel, int bend) {
            double fraction = (double)(bend - 8192) / 8192.0;
            System.out.println("bend = " + bend + ", fraction = " + fraction);
        }
    }
}

