/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.data.SequentialData;
import com.jsyn.exceptions.ChannelMismatchException;
import com.jsyn.ports.QueueDataCommand;
import com.jsyn.ports.QueueDataEvent;
import com.jsyn.ports.UnitPort;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;
import java.util.LinkedList;

public class UnitDataQueuePort
extends UnitPort {
    private LinkedList<QueuedBlock> blocks = new LinkedList();
    private QueueDataCommand currentBlock;
    private int frameIndex;
    private int numChannels = 1;
    private double normalizedRate;
    private long framesMoved;
    private boolean autoStopPending;
    private boolean targetValid;
    private QueueDataCommand finishingBlock;
    private QueueDataCommand loopingBlock;
    public static final int LOOP_IF_LAST = -1;

    public UnitDataQueuePort(String name) {
        super(name);
    }

    protected void setupCrossFade(QueueDataCommand sourceCommand, int sourceStartIndex, QueueDataCommand targetCommand) {
        int crossFrames = targetCommand.getCrossFadeIn();
        SequentialData sourceData = sourceCommand.getCurrentData();
        SequentialData targetData = targetCommand.getCurrentData();
        int remainingSource = sourceData.getNumFrames() - sourceStartIndex;
        if (crossFrames > remainingSource) {
            crossFrames = remainingSource;
        }
        if (crossFrames > 0) {
            int remainingTarget = targetData.getNumFrames() - targetCommand.getStartFrame();
            targetCommand.crossfadeData.setup(sourceData, sourceStartIndex, crossFrames, targetData, targetCommand.getStartFrame(), remainingTarget);
            targetCommand.currentData = targetCommand.crossfadeData;
            targetCommand.startFrame = 0;
        }
    }

    public QueueDataCommand createQueueDataCommand(SequentialData queueableData) {
        return this.createQueueDataCommand(queueableData, 0, queueableData.getNumFrames());
    }

    public QueueDataCommand createQueueDataCommand(SequentialData queueableData, int startFrame, int numFrames) {
        if (queueableData.getChannelsPerFrame() != this.numChannels) {
            throw new ChannelMismatchException("Tried to queue " + queueableData.getChannelsPerFrame() + " channel data to a " + this.numChannels + " channel port.");
        }
        return new QueuedBlock(queueableData, startFrame, numFrames);
    }

    public QueueDataCommand getEndBlock() {
        if (this.blocks.size() > 0) {
            return this.blocks.getLast();
        }
        if (this.currentBlock != null) {
            return this.currentBlock;
        }
        return null;
    }

    public void setCurrentBlock(QueueDataCommand currentBlock) {
        this.currentBlock = currentBlock;
    }

    public void firePendingCallbacks() {
        if (this.loopingBlock != null) {
            if (this.loopingBlock.getCallback() != null) {
                this.loopingBlock.getCallback().looped(this.currentBlock);
            }
            this.loopingBlock = null;
        }
        if (this.finishingBlock != null) {
            if (this.finishingBlock.getCallback() != null) {
                this.finishingBlock.getCallback().finished(this.currentBlock);
            }
            this.finishingBlock = null;
        }
    }

    public boolean hasMore() {
        return this.currentBlock != null || this.blocks.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBlock() {
        if (this.currentBlock == null) {
            LinkedList<QueuedBlock> linkedList = this.blocks;
            synchronized (linkedList) {
                this.setCurrentBlock(this.blocks.remove());
                this.frameIndex = this.currentBlock.getStartFrame();
                this.currentBlock.loopsLeft = this.currentBlock.getNumLoops();
                if (this.currentBlock.getCallback() != null) {
                    this.currentBlock.getCallback().started(this.currentBlock);
                }
            }
        }
    }

    private void advanceFrameIndex() {
        ++this.frameIndex;
        ++this.framesMoved;
        if (this.frameIndex >= this.currentBlock.getStartFrame() + this.currentBlock.getNumFrames()) {
            if (this.currentBlock.loopsLeft > 0) {
                --this.currentBlock.loopsLeft;
                this.loopToStart();
            } else if (this.blocks.size() == 0 && this.currentBlock.loopsLeft < 0) {
                this.loopToStart();
            } else {
                if (this.currentBlock.isAutoStop()) {
                    this.autoStopPending = true;
                }
                this.finishingBlock = this.currentBlock;
                this.setCurrentBlock(null);
            }
        }
    }

    private void loopToStart() {
        if (this.currentBlock.getCrossFadeIn() > 0) {
            this.setupCrossFade(this.currentBlock, this.frameIndex, this.currentBlock);
        }
        this.frameIndex = this.currentBlock.getStartFrame();
        this.loopingBlock = this.currentBlock;
    }

    public double getNormalizedRate() {
        return this.normalizedRate;
    }

    public double readCurrentChannelDouble(int channelIndex) {
        return this.currentBlock.currentData.readDouble(this.frameIndex * this.numChannels + channelIndex);
    }

    public void writeCurrentChannelDouble(int channelIndex, double value) {
        this.currentBlock.currentData.writeDouble(this.frameIndex * this.numChannels + channelIndex, value);
    }

    public void beginFrame(double synthesisPeriod) {
        this.checkBlock();
        this.normalizedRate = this.currentBlock.currentData.getRateScaler(this.frameIndex, synthesisPeriod);
    }

    public void endFrame() {
        this.advanceFrameIndex();
        this.targetValid = true;
    }

    public double readNextMonoDouble(double synthesisPeriod) {
        this.beginFrame(synthesisPeriod);
        double value = this.currentBlock.currentData.readDouble(this.frameIndex);
        this.endFrame();
        return value;
    }

    protected void addQueuedBlock(QueueDataEvent block) {
        this.blocks.add((QueuedBlock)block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearQueue() {
        LinkedList<QueuedBlock> linkedList = this.blocks;
        synchronized (linkedList) {
            this.blocks.clear();
            this.setCurrentBlock(null);
            this.targetValid = false;
            this.autoStopPending = false;
        }
    }

    public void queue(SequentialData queueableData, int startFrame, int numFrames, TimeStamp timeStamp) {
        QueueDataCommand command = this.createQueueDataCommand(queueableData, startFrame, numFrames);
        this.scheduleCommand(timeStamp, command);
    }

    public void queueImmediate(SequentialData queueableData, int startFrame, int numFrames, TimeStamp timeStamp) {
        QueueDataCommand command = this.createQueueDataCommand(queueableData, startFrame, numFrames);
        command.setImmediate(true);
        this.scheduleCommand(timeStamp, command);
    }

    public void queueLoop(SequentialData queueableData, int startFrame, int numFrames, TimeStamp timeStamp) {
        this.queueLoop(queueableData, startFrame, numFrames, -1, timeStamp);
    }

    public void queueLoop(SequentialData queueableData, int startFrame, int numFrames, int numLoops, TimeStamp timeStamp) {
        QueueDataCommand command = this.createQueueDataCommand(queueableData, startFrame, numFrames);
        command.setNumLoops(numLoops);
        this.scheduleCommand(timeStamp, command);
    }

    public void queueLoop(SequentialData queueableData) {
        this.queueLoop(queueableData, 0, queueableData.getNumFrames());
    }

    public void queueLoop(SequentialData queueableData, int startFrame, int numFrames) {
        this.queueLoop(queueableData, startFrame, numFrames, -1);
    }

    public void queueLoop(SequentialData queueableData, int startFrame, int numFrames, int numLoops) {
        QueueDataCommand command = this.createQueueDataCommand(queueableData, startFrame, numFrames);
        command.setNumLoops(numLoops);
        this.queueCommand(command);
    }

    public void queueStop(SequentialData queueableData, int startFrame, int numFrames, TimeStamp timeStamp) {
        QueueDataCommand command = this.createQueueDataCommand(queueableData, startFrame, numFrames);
        command.setAutoStop(true);
        this.scheduleCommand(timeStamp, command);
    }

    public void queue(SequentialData queueableData, int startFrame, int numFrames) {
        QueueDataCommand command = this.createQueueDataCommand(queueableData, startFrame, numFrames);
        this.queueCommand(command);
    }

    public void queue(SequentialData queueableData) {
        this.queue(queueableData, 0, queueableData.getNumFrames());
    }

    public void queueOn(SequentialData queueableData) {
        this.queueOn(queueableData, this.getSynthesisEngine().createTimeStamp());
    }

    public void queueOff(SequentialData queueableData) {
        this.queueOff(queueableData, false);
    }

    public void queueOff(SequentialData queueableData, boolean ifStop) {
        this.queueOff(queueableData, ifStop, this.getSynthesisEngine().createTimeStamp());
    }

    public void queueOn(SequentialData queueableData, TimeStamp timeStamp) {
        if (queueableData.getSustainBegin() < 0) {
            if (queueableData.getReleaseBegin() < 0) {
                this.queueImmediate(queueableData, 0, queueableData.getNumFrames(), timeStamp);
            } else {
                this.queueImmediate(queueableData, 0, queueableData.getReleaseEnd(), timeStamp);
                int size = queueableData.getReleaseEnd() - queueableData.getReleaseBegin();
                this.queueLoop(queueableData, queueableData.getReleaseBegin(), size, timeStamp);
            }
        } else if (queueableData.getSustainEnd() > 0) {
            int frontSize = queueableData.getSustainBegin();
            int loopSize = queueableData.getSustainEnd() - queueableData.getSustainBegin();
            if (frontSize > 0) {
                this.queueImmediate(queueableData, 0, frontSize, timeStamp);
            }
            if ((loopSize = queueableData.getSustainEnd() - queueableData.getSustainBegin()) > 0) {
                this.queueLoop(queueableData, queueableData.getSustainBegin(), loopSize, timeStamp);
            }
        }
    }

    public void queueOff(SequentialData queueableData, boolean ifStop, TimeStamp timeStamp) {
        if (queueableData.getSustainBegin() >= 0) {
            int relSize = queueableData.getReleaseEnd() - queueableData.getReleaseBegin();
            if (queueableData.getReleaseBegin() < 0) {
                int susEnd = queueableData.getSustainEnd();
                int size = queueableData.getNumFrames() - susEnd;
                if (size <= 0) {
                    size = 1;
                    susEnd = queueableData.getNumFrames() - 1;
                }
                if (ifStop) {
                    this.queueStop(queueableData, susEnd, size, timeStamp);
                } else {
                    this.queue(queueableData, susEnd, size, timeStamp);
                }
            } else if (queueableData.getReleaseBegin() > queueableData.getSustainEnd()) {
                this.queue(queueableData, queueableData.getSustainEnd(), queueableData.getReleaseEnd() - queueableData.getSustainEnd(), timeStamp);
                if (relSize > 0) {
                    this.queueLoop(queueableData, queueableData.getReleaseBegin(), relSize, timeStamp);
                }
            } else if (relSize > 0) {
                this.queueLoop(queueableData, queueableData.getReleaseBegin(), relSize, timeStamp);
            }
        }
    }

    public void clear(TimeStamp timeStamp) {
        ClearQueueCommand command = new ClearQueueCommand();
        this.scheduleCommand(timeStamp, command);
    }

    public void clear() {
        ClearQueueCommand command = new ClearQueueCommand();
        this.queueCommand(command);
    }

    public void writeNextDouble(double value) {
        this.checkBlock();
        this.currentBlock.currentData.writeDouble(this.frameIndex, value);
        this.advanceFrameIndex();
    }

    public long getFrameCount() {
        return this.framesMoved;
    }

    public boolean testAndClearAutoStop() {
        boolean temp = this.autoStopPending;
        this.autoStopPending = false;
        return temp;
    }

    public boolean isTargetValid() {
        return this.targetValid;
    }

    public void setNumChannels(int numChannels) {
        this.numChannels = numChannels;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    class ClearQueueCommand
    implements ScheduledCommand {
        ClearQueueCommand() {
        }

        @Override
        public void run() {
            UnitDataQueuePort.this.clearQueue();
        }
    }

    private class QueuedBlock
    extends QueueDataCommand {
        public QueuedBlock(SequentialData queueableData, int startFrame, int numFrames) {
            super(UnitDataQueuePort.this, queueableData, startFrame, numFrames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList linkedList = UnitDataQueuePort.this.blocks;
            synchronized (linkedList) {
                QueueDataEvent lastBlock;
                if (UnitDataQueuePort.this.blocks.size() > 0 && (lastBlock = (QueueDataEvent)UnitDataQueuePort.this.blocks.getLast()).isSkipIfOthers()) {
                    UnitDataQueuePort.this.blocks.removeLast();
                }
                if (this.getCrossFadeIn() > 0) {
                    if (this.isImmediate()) {
                        if (UnitDataQueuePort.this.currentBlock != null) {
                            UnitDataQueuePort.this.setupCrossFade(UnitDataQueuePort.this.currentBlock, UnitDataQueuePort.this.frameIndex, this);
                        }
                    } else {
                        QueueDataCommand endBlock = UnitDataQueuePort.this.getEndBlock();
                        if (endBlock != null) {
                            UnitDataQueuePort.this.setupCrossFade(endBlock, endBlock.getStartFrame() + endBlock.getNumFrames(), this);
                        }
                    }
                }
                if (this.isImmediate()) {
                    UnitDataQueuePort.this.clearQueue();
                }
                UnitDataQueuePort.this.blocks.add(this);
            }
        }
    }
}

