/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.scope;

import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.scope.AudioScopeModel;
import com.jsyn.scope.AudioScopeProbe;
import com.jsyn.scope.swing.AudioScopeView;

public class AudioScope {
    private AudioScopeView audioScopeView = null;
    private AudioScopeModel audioScopeModel;

    public AudioScope(Synthesizer synth) {
        this.audioScopeModel = new AudioScopeModel(synth);
    }

    public AudioScopeProbe addProbe(UnitOutputPort output) {
        return this.addProbe(output, 0);
    }

    public AudioScopeProbe addProbe(UnitOutputPort output, int partIndex) {
        return this.audioScopeModel.addProbe(output, partIndex);
    }

    public void start() {
        this.audioScopeModel.start();
    }

    public void stop() {
        this.audioScopeModel.stop();
    }

    public AudioScopeModel getModel() {
        return this.audioScopeModel;
    }

    public AudioScopeView getView() {
        if (this.audioScopeView == null) {
            this.audioScopeView = new AudioScopeView();
            this.audioScopeView.setModel(this.audioScopeModel);
        }
        return this.audioScopeView;
    }

    public void setTriggerMode(TriggerMode triggerMode) {
        this.audioScopeModel.setTriggerMode(triggerMode);
    }

    public void setTriggerSource(AudioScopeProbe probe) {
        this.audioScopeModel.setTriggerSource(probe);
    }

    public void setTriggerLevel(double level) {
        this.getModel().getTriggerModel().getLevelModel().setDoubleValue(level);
    }

    public double getTriggerLevel() {
        return this.getModel().getTriggerModel().getLevelModel().getDoubleValue();
    }

    public static enum TriggerMode {
        AUTO,
        NORMAL;

    }
}

