/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.tutorial;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.view102.PortFader;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;

public class TUT_Vibrato
extends Applet {
    SineOscillator modOsc;
    TriangleOscillator triOsc;
    AddUnit freqAdder;
    MultiplyUnit modScaler;
    LineOut lineOut;
    PortFader centerFader;
    PortFader modFreqFader;
    PortFader modRangeFader;
    static final double MAX_MOD_DEPTH = 100.0;

    public static void main(String[] args) {
        TUT_Vibrato applet = new TUT_Vibrato();
        AppletFrame frame = new AppletFrame("Test JSyn", applet);
        frame.resize(500, 140);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.modOsc = new SineOscillator();
            this.triOsc = new TriangleOscillator();
            this.freqAdder = new AddUnit();
            this.lineOut = new LineOut();
            this.modOsc.output.connect(this.freqAdder.inputA);
            this.freqAdder.output.connect(this.triOsc.frequency);
            this.triOsc.output.connect(0, this.lineOut.input, 0);
            this.triOsc.output.connect(0, this.lineOut.input, 1);
            this.centerFader = new PortFader(this.freqAdder.inputB, "Center Frequency", 330.0, 0.0, 500.0);
            this.add(this.centerFader);
            this.modFreqFader = new PortFader(this.modOsc.frequency, "Modulation Frequency", 2.0, 0.0, 50.0);
            this.add(this.modFreqFader);
            this.modRangeFader = new PortFader(this.modOsc.amplitude, "Modulation Depth", 0.0, 0.0, 100.0);
            this.add(this.modRangeFader);
            this.modScaler = new MultiplyUnit();
            this.modOsc.output.connect(this.modScaler.inputA);
            this.modScaler.inputB.set(0.01);
            this.getParent().validate();
            this.getToolkit().sync();
            this.modOsc.start();
            this.freqAdder.start();
            this.triOsc.start();
            this.lineOut.start();
            this.modScaler.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

