/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitFilter;

public class LinearRamp
extends UnitFilter {
    public UnitInputPort time = new UnitInputPort("Time");
    public UnitVariablePort current;
    private double source;
    private double phase;
    private double target;
    private double timeHeld = 0.0;
    private double rate = 1.0;

    public LinearRamp() {
        this.addPort(this.time);
        this.current = new UnitVariablePort("Current");
        this.addPort(this.current);
    }

    @Override
    public void generate(int start, int limit) {
        double[] outputs = this.output.getValues();
        double currentInput = this.input.getValues()[0];
        double currentTime = this.time.getValues()[0];
        double currentValue = this.current.getValue();
        if (currentTime != this.timeHeld) {
            this.rate = this.convertTimeToRate(currentTime);
            this.timeHeld = currentTime;
        }
        if (currentInput != this.target) {
            this.source = currentValue;
            this.phase = 0.0;
            this.target = currentInput;
        }
        int i = start;
        while (i < limit) {
            if (this.phase < 1.0) {
                currentValue = this.source + this.phase * (this.target - this.source);
                this.phase += this.rate;
            } else {
                currentValue = this.target;
            }
            outputs[i] = currentValue;
            ++i;
        }
        this.current.setValue(currentValue);
    }
}

