/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.SpectralWindow;
import com.jsyn.data.SpectralWindowFactory;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitSpectralInputPort;
import com.jsyn.ports.UnitSpectralOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.SpectralFFT;
import com.jsyn.unitgen.SpectralIFFT;
import com.jsyn.unitgen.UnitSink;
import com.jsyn.unitgen.UnitSource;

public class SpectralFilter
extends Circuit
implements UnitSink,
UnitSource {
    public UnitInputPort input;
    public UnitOutputPort output;
    private SpectralFFT[] ffts;
    private SpectralIFFT[] iffts;
    private PassThrough inlet = new PassThrough();
    private PassThrough sum;

    public SpectralFilter() {
        this(2, 9);
    }

    public SpectralFilter(int numFFTs, int sizeLog2) {
        this.add(this.inlet);
        this.sum = new PassThrough();
        this.add(this.sum);
        this.ffts = new SpectralFFT[numFFTs];
        this.iffts = new SpectralIFFT[numFFTs];
        int offset = (1 << sizeLog2) / numFFTs;
        int i = 0;
        while (i < numFFTs) {
            this.ffts[i] = new SpectralFFT(sizeLog2);
            this.add(this.ffts[i]);
            this.inlet.output.connect(this.ffts[i].input);
            this.ffts[i].setOffset(i * offset);
            this.iffts[i] = new SpectralIFFT();
            this.add(this.iffts[i]);
            this.iffts[i].output.connect(this.sum.input);
            ++i;
        }
        this.setWindow(SpectralWindowFactory.getHammingWindow(sizeLog2));
        this.input = this.inlet.input;
        this.addPort(this.input);
        this.output = this.sum.output;
        this.addPort(this.output);
    }

    public SpectralWindow getWindow() {
        return this.ffts[0].getWindow();
    }

    public void setWindow(SpectralWindow window) {
        int i = 0;
        while (i < this.ffts.length) {
            this.ffts[i].setWindow(window);
            this.iffts[i].setWindow(window);
            ++i;
        }
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }

    @Override
    public UnitInputPort getInput() {
        return this.input;
    }

    public UnitSpectralOutputPort getSpectralOutput(int i) {
        return this.ffts[i].output;
    }

    public UnitSpectralInputPort getSpectralInput(int i) {
        return this.iffts[i].input;
    }
}

