/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.compose.swing;

import com.jsyn.util.VoiceAllocator;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.score.ScoreClock;
import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreInstrument;
import com.softsynth.score.ScoreNote;
import com.softsynth.shared.time.TimeStamp;

public class BasicScoreInstrument
implements ScoreInstrument {
    private VoiceAllocator allocator;
    private byte nextTag = 1;
    private ScoreClock scoreClock;

    public BasicScoreInstrument(ScoreClock scoreClock, VoiceAllocator allocator) {
        this.scoreClock = scoreClock;
        this.allocator = allocator;
    }

    public synchronized void noteOnFor(double frequency, double time, double duration) {
        this.noteOnFor(frequency, 0.2, time, duration);
    }

    public void noteOn(byte noteNumber, double frequency, double amplitude, double scoreTime) {
        double realTime = this.scoreClock.convertScoreTimeToRealTime(scoreTime);
        TimeStamp timeStamp = new TimeStamp(realTime);
        this.allocator.noteOn(noteNumber, frequency, amplitude, timeStamp);
    }

    public void noteOff(byte noteNumber, double frequency, double amplitude, double scoreTime) {
        double realTime = this.scoreClock.convertScoreTimeToRealTime(scoreTime);
        TimeStamp timeStamp = new TimeStamp(realTime);
        this.allocator.noteOff(noteNumber, timeStamp);
    }

    public void noteOnFor(double frequency, double amplitude, double time, double duration) {
        byte noteNumber = this.nextNoteNumber();
        this.noteOn(noteNumber, frequency, amplitude, time);
        this.noteOff(noteNumber, frequency, amplitude, time + duration);
    }

    @Override
    public void play(ScoreElement element, double time, double amplitude) {
        if (element instanceof ScoreNote) {
            ScoreNote note = (ScoreNote)element;
            double pitch = note.getValue();
            double frequency = EqualTemperedTuning.getMIDIFrequency(pitch);
            byte noteNumber = this.nextNoteNumber();
            this.noteOn(noteNumber, frequency, amplitude, time);
            this.noteOff(noteNumber, frequency, amplitude, time + note.getOnTime());
        }
    }

    public byte nextNoteNumber() {
        this.nextTag = (byte)(this.nextTag + 1 & 0x7F);
        return this.nextTag;
    }
}

