/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.ezxml;

import com.softsynth.ezxml.NameValuePair;
import com.softsynth.ezxml.XMLWriter;
import java.io.IOException;
import java.util.Vector;

public class XMLElement {
    private String name;
    private Vector<Object> contentItems = new Vector();
    private Vector<NameValuePair> attributes = new Vector();

    public XMLElement(String name) {
        this();
        this.name = name;
    }

    public XMLElement() {
    }

    public void addAttribute(String name, String value) {
        NameValuePair pair = new NameValuePair(name, value);
        this.attributes.add(pair);
    }

    public void addChild(XMLElement child) {
        this.contentItems.add(child);
    }

    public void save(XMLWriter writer) throws IOException {
        writer.beginTag(this.name);
        for (NameValuePair pair : this.attributes) {
            writer.writeAttribute(pair.getName(), pair.getValue());
        }
        this.saveContent(writer);
        writer.endTag();
    }

    private void saveContent(XMLWriter writer) throws IOException {
        if (this.contentItems.size() > 0) {
            writer.beginContent();
            this.saveChildren(writer);
            writer.endContent();
        }
    }

    protected void saveChildren(XMLWriter writer) throws IOException {
        for (Object item : this.contentItems) {
            if (item instanceof XMLElement) {
                XMLElement child = (XMLElement)item;
                child.save(writer);
                continue;
            }
            if (item instanceof String) {
                writer.writeContent((String)item);
                continue;
            }
            throw new IOException("Illegal XML content = " + item);
        }
    }

    public void addContent(String content) {
        this.contentItems.add(content);
    }

    public void addContent(int n) {
        this.addContent(Integer.toString(n));
    }

    public void addAttribute(String string, int n) {
        this.addAttribute(string, Integer.toString(n));
    }

    public void addAttribute(String string, long l) {
        this.addAttribute(string, Long.toString(l));
    }

    public void addAttribute(String string, boolean flag) {
        this.addAttribute(string, flag ? "yes" : "no");
    }
}

