/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.ezxml;

import com.softsynth.ezxml.IndentingWriter;
import java.io.OutputStream;
import java.util.Stack;

public class XMLWriter
extends IndentingWriter {
    Stack<String> tagStack = new Stack();
    boolean hasContent = false;

    public XMLWriter(OutputStream stream) {
        super(stream);
    }

    public static String escapeText(String text) {
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        text = text.replaceAll("\"", "&quot;");
        text = text.replaceAll("'", "&apos;");
        text = text.replaceAll("\r", "&#x0D;");
        text = text.replaceAll("\n", "&#x0A;");
        return text;
    }

    public void writeAttribute(String name, String value) {
        String safeValue = XMLWriter.escapeText(value);
        this.print(" " + name + "=\"" + safeValue + "\"");
        this.wrapAt(80);
    }

    public void writeAttribute(String name, int value) {
        this.writeAttribute(name, Integer.toString(value));
    }

    public void writeAttribute(String name, long value) {
        this.writeAttribute(name, Long.toString(value));
    }

    public void writeAttribute(String name, double value) {
        this.writeAttribute(name, Double.toString(value));
    }

    public void writeAttribute(String name, boolean value) {
        this.writeAttribute(name, value ? "1" : "0");
    }

    public void writeHeader(String encoding) {
        this.print("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
    }

    public void startTag(String name) {
        this.beginTag(name);
    }

    public void beginTag(String name) {
        this.newLine();
        this.print("<" + name);
        this.tagStack.push(name);
        this.hasContent = false;
        this.indent();
    }

    public void endTag() {
        this.undent();
        String name = this.tagStack.pop();
        if (this.hasContent) {
            this.println("</" + name + ">");
        } else {
            this.println(" />");
        }
        this.hasContent = !this.tagStack.isEmpty();
    }

    public void beginContent() {
        this.print(">");
        this.hasContent = true;
    }

    public void endContent() {
    }

    public void writeComment(String text) {
        this.beginTag("comment");
        this.beginContent();
        this.print(text);
        this.endContent();
        this.endTag();
    }

    public void writeContent(String content) {
        this.print(XMLWriter.escapeText(content));
    }
}

