/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.install;

import com.softsynth.install.InstallerGUI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;

public class Installer {
    InstallerGUI gui;
    private int host;
    static final int HOST_UNKNOWN = 0;
    static final int HOST_WINDOWS = 1;
    static final int HOST_MACINTOSH = 2;
    static final int HOST_UNIX = 3;

    public Installer(InstallerGUI gui) {
        this.gui = gui;
    }

    void print(String msg) {
        this.gui.print(msg);
    }

    void println(String msg) {
        this.gui.println(msg);
    }

    void showProperties() {
        this.println("==================== System Properties ====================");
        this.showProp("java.version");
        this.showProp("java.vendor");
        this.showProp("os.name");
        this.showProp("os.arch");
        this.showProp("os.version");
        this.showProp("java.library.path");
        this.showProp("java.ext.dirs");
    }

    void showProp(String key) {
        try {
            String value = System.getProperty(key);
            if (value == null) {
                value = "UNDEFINED";
            }
            this.println(String.valueOf(key) + " = " + value);
        }
        catch (SecurityException e) {
            this.println(e + " accessing " + key);
        }
    }

    public void createDirectoryIfNeeded(File libDir) {
        if (!libDir.isDirectory() && !libDir.mkdirs()) {
            this.gui.println("Could not make output directory " + libDir.getAbsoluteFile());
        }
    }

    private void addIfUnique(Vector vector, Object object) {
        boolean found = false;
        Enumeration enumer = vector.elements();
        while (enumer.hasMoreElements()) {
            Object inVector = enumer.nextElement();
            if (!inVector.equals(object)) continue;
            found = true;
            break;
        }
        if (!found) {
            vector.addElement(object);
        }
    }

    protected Vector splitString(String text, char separator) {
        int index;
        Vector strings = new Vector();
        int last = 0;
        while ((index = text.indexOf(separator, last)) >= 0) {
            String temp = text.substring(last, index);
            this.addIfUnique(strings, temp);
            last = index + 1;
        }
        this.addIfUnique(strings, text.substring(last));
        return strings;
    }

    int determineHost() {
        String osName;
        if (this.host == 0 && (osName = System.getProperty("os.name")) != null) {
            this.host = osName.startsWith("Windows") ? 1 : (osName.startsWith("Unix") ? 3 : (osName.startsWith("Mac") ? 2 : 0));
        }
        return this.host;
    }

    int countExistingInstallations(String path, String libraryFileName) {
        int count = 0;
        try {
            this.gui.println("Looking for installed files:");
            if (path != null) {
                Vector strings = this.splitString(path, File.pathSeparatorChar);
                this.gui.println("Scanning  " + strings.size() + " folders.");
                Enumeration dirs = strings.elements();
                while (dirs.hasMoreElements()) {
                    String dirName = (String)dirs.nextElement();
                    String libPathName = String.valueOf(dirName) + File.separator + libraryFileName;
                    File libFile = new File(libPathName);
                    if (libFile.exists()) {
                        ++count;
                        this.gui.println("FOUND - " + libFile.getAbsoluteFile() + " = " + libFile.length() + " bytes!");
                        continue;
                    }
                    this.gui.println("      - " + libFile.getParent());
                }
            }
        }
        catch (SecurityException e) {
            this.gui.println("Caught " + e);
        }
        return count;
    }

    public static File getMacUserExtensionFolder() {
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            return new File(String.valueOf(userHome) + "/Library/Java/Extensions");
        }
        return null;
    }

    private File[] getMacPreferredFolders() {
        File[] preferredFolders = new File[]{Installer.getMacUserExtensionFolder(), new File("/Library/Java/Extensions")};
        if (preferredFolders[0] == null) {
            preferredFolders[0] = preferredFolders[1];
        }
        return preferredFolders;
    }

    protected File getWindowsJavaTrustedFolder() {
        return new File("C:\\WINDOWS\\Sun\\Java\\Deployment\\Lib\\Trusted");
    }

    protected File getWindowsJavaBinFolder() {
        return new File("C:\\WINDOWS\\Sun\\Java\\bin");
    }

    private File[] getWindowsPreferredNativeFolders() {
        File[] preferredFolders;
        String javaHome;
        preferredFolders = new File[]{this.getWindowsJavaBinFolder(), (javaHome = System.getProperty("java.home")) != null ? new File(String.valueOf(javaHome) + "\\bin") : preferredFolders[0], new File("C:\\WINDOWS\\System32")};
        preferredFolders[2] = new File("C:\\WINDOWS\\System");
        return preferredFolders;
    }

    private File[] getWindowsPreferredExtensionFolders() {
        File[] preferredFolders;
        String javaHome;
        preferredFolders = new File[]{this.getWindowsJavaTrustedFolder(), (javaHome = System.getProperty("java.home")) != null ? new File(String.valueOf(javaHome) + "\\lib\\ext") : preferredFolders[0]};
        return preferredFolders;
    }

    File getBestDirectoryName(String path, File[] preferredFolders) {
        Vector strings = this.splitString(path, File.pathSeparatorChar);
        Enumeration files = strings.elements();
        while (files.hasMoreElements()) {
            File listedFolder = new File((String)files.nextElement());
            int i = 0;
            while (i < preferredFolders.length) {
                File preferredFolder = preferredFolders[i];
                if (listedFolder.equals(preferredFolder)) {
                    return preferredFolder;
                }
                ++i;
            }
        }
        return new File((String)strings.elementAt(0));
    }

    File getNativeDirectory() {
        File result = null;
        File[] preferredFolders = null;
        if (this.determineHost() == 2) {
            preferredFolders = this.getMacPreferredFolders();
        } else if (this.determineHost() == 1) {
            preferredFolders = this.getWindowsPreferredNativeFolders();
        }
        String path = System.getProperty("java.library.path");
        if (path != null) {
            result = this.getBestDirectoryName(path, preferredFolders);
        }
        if (result == null) {
            result = preferredFolders[0];
        }
        return result;
    }

    File getExtensionDirectory() {
        File result = null;
        File[] preferredFolders = null;
        if (this.determineHost() == 2) {
            preferredFolders = this.getMacPreferredFolders();
        } else if (this.determineHost() == 1) {
            preferredFolders = this.getWindowsPreferredExtensionFolders();
        }
        String path = System.getProperty("java.ext.dirs");
        if (path != null) {
            result = this.getBestDirectoryName(path, preferredFolders);
        }
        if (result == null) {
            result = preferredFolders[0];
        }
        return result;
    }

    boolean copyURLToStream(URL url, OutputStream outStream) throws IOException {
        boolean error = false;
        URLConnection conn = url.openConnection();
        int contentLength = conn.getContentLength();
        InputStream inStream = conn.getInputStream();
        byte[] data = new byte[2048];
        int totalBytes = 0;
        try {
            int numRead;
            while ((numRead = inStream.read(data)) >= 0) {
                outStream.write(data, 0, numRead);
                this.downloadProgressed(contentLength, totalBytes += numRead);
            }
        }
        finally {
            inStream.close();
            String result = "SUCCESS - Downloaded ";
            if (totalBytes < contentLength) {
                result = "WARNING! - Only downloaded ";
                error = true;
            }
            this.gui.println(String.valueOf(result) + totalBytes + " out of " + contentLength + " bytes.");
        }
        return error;
    }

    private void copyURLToFile(URL url, File destFile) throws IOException {
        this.gui.println("Copy: " + url);
        this.gui.println("  to: " + destFile.getCanonicalPath());
        boolean exists = destFile.exists();
        FileOutputStream outStream = null;
        try {
            boolean error = true;
            int MAX_TRIES = 3;
            int i = 0;
            while (i < 3 && error) {
                if (i > 0) {
                    this.gui.println("Try again....");
                }
                outStream = new FileOutputStream(destFile);
                try {
                    error = this.copyURLToStream(url, outStream);
                }
                finally {
                    outStream.close();
                }
                ++i;
            }
            if (error) {
                throw new IOException("Failed after multiple attempts to download " + url);
            }
        }
        catch (IOException exc) {
            if (exists) {
                this.gui.println("Existing Java component " + destFile.getAbsoluteFile() + " was probably in use.");
                this.gui.println("Restart browser and reinstall before using plugin.");
            }
            throw exc;
        }
    }

    void downloadProgressed(int total, int soFar) {
        double fraction = (double)soFar / (double)total;
        this.gui.showProgress("Downloaded  " + soFar + " out of " + total + " bytes ", fraction);
    }

    void cleanupNativeInExtension(String fileName) {
        File badFile = new File(this.getExtensionDirectory(), fileName);
        if (badFile.exists()) {
            if (!badFile.delete()) {
                badFile.deleteOnExit();
                this.gui.println("Scheduled " + badFile.getAbsoluteFile() + " for deletion.");
            } else {
                this.gui.println("Deleted " + badFile.getAbsoluteFile());
            }
        }
    }

    void printHeader(String name) {
        this.gui.println("================ Installing " + name + " =============");
    }

    private String makeCacheDefeatingQuery() {
        String timeText = "" + System.currentTimeMillis();
        timeText = timeText.substring(timeText.length() - 6);
        return "?time=" + timeText;
    }

    void installNativeLibrary(String libraryNameOnServer, String libraryName, String urlDir) throws IOException {
        this.printHeader(libraryName);
        String libraryFileName = System.mapLibraryName(libraryName);
        this.countExistingInstallations(System.getProperty("java.library.path"), libraryFileName);
        File libDir = this.getNativeDirectory();
        String libraryFileNameOnServer = System.mapLibraryName(libraryNameOnServer);
        URL url = new URL(String.valueOf(urlDir) + "/" + libraryFileNameOnServer + this.makeCacheDefeatingQuery());
        File targetFile = new File(libDir, libraryFileName);
        this.downloadURLtoFile(url, targetFile);
        this.gui.println("Native component " + libraryFileName + " downloaded successfully.");
    }

    private void downloadURLtoFile(URL url, File file) throws IOException {
        this.createDirectoryIfNeeded(file.getParentFile());
        this.copyURLToFile(url, file);
    }

    void installJar(String jarName, String urlDir) throws IOException {
        this.printHeader(jarName);
        File extDir = this.getExtensionDirectory();
        URL url = new URL(String.valueOf(urlDir) + "/" + jarName + this.makeCacheDefeatingQuery());
        File targetFile = new File(extDir, jarName);
        this.downloadURLtoFile(url, targetFile);
        this.gui.println("JAR file " + jarName + " downloaded successfully.");
        this.gui.println("Note: you must restart your browser before running any Applets!");
    }
}

