/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.jsyn.data.SegmentedEnvelope;
import java.util.Vector;

public class EnvelopePoints
extends Vector {
    String name = "";
    double maximumValue = 1.0;
    int sustainBegin = -1;
    int sustainEnd = -1;
    int releaseBegin = -1;
    int releaseEnd = -1;

    public void updateEnvelope(SegmentedEnvelope envelope) {
        int numFrames = this.size();
        int i = 0;
        while (i < numFrames) {
            envelope.write(i, this.getPoint(i), 0, 1);
            ++i;
        }
        envelope.setSustainBegin(this.getSustainBegin());
        envelope.setSustainEnd(this.getSustainEnd());
        envelope.setReleaseBegin(this.getReleaseBegin());
        envelope.setReleaseEnd(this.getReleaseEnd());
        envelope.setNumFrames(numFrames);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setMaximumValue(double maximumValue) {
        this.maximumValue = maximumValue;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public void add(double dur, double value) {
        double[] dar = new double[]{dur, value};
        this.addElement(dar);
    }

    public void insert(int index, double dur, double y) {
        double[] dar = new double[]{dur, y};
        if (index < this.size()) {
            double[] dArray = (double[])this.elementAt(index);
            dArray[0] = dArray[0] - dur;
        }
        this.insertElementAt(dar, index);
        if (index <= this.sustainBegin) {
            ++this.sustainBegin;
        }
        if (index <= this.sustainEnd) {
            ++this.sustainEnd;
        }
        if (index <= this.releaseBegin) {
            ++this.releaseBegin;
        }
        if (index <= this.releaseEnd) {
            ++this.releaseEnd;
        }
    }

    public void removePoint(int index) {
        super.removeElementAt(index);
        if (index < this.sustainBegin) {
            --this.sustainBegin;
        }
        if (index <= this.sustainEnd) {
            --this.sustainEnd;
        }
        if (index < this.releaseBegin) {
            --this.releaseBegin;
        }
        if (index <= this.releaseEnd) {
            --this.releaseEnd;
        }
        if (this.sustainBegin > this.sustainEnd) {
            this.sustainBegin = -1;
            this.sustainEnd = -1;
        }
        if (this.releaseBegin > this.releaseEnd) {
            this.releaseBegin = -1;
            this.releaseEnd = -1;
        }
    }

    public double[] getPoint(int index) {
        return (double[])this.elementAt(index);
    }

    public double getTotalDuration() {
        double sum = 0.0;
        int i = 0;
        while (i < this.size()) {
            double[] dar = (double[])this.elementAt(i);
            sum += dar[0];
            ++i;
        }
        return sum;
    }

    public void setSustainLoop(int startFrame, int endFrame) {
        this.sustainBegin = startFrame;
        this.sustainEnd = endFrame;
    }

    public int getSustainBegin() {
        return this.sustainBegin;
    }

    public int getSustainEnd() {
        return this.sustainEnd;
    }

    public int getSustainSize() {
        return this.sustainEnd - this.sustainBegin;
    }

    public void setReleaseLoop(int startFrame, int endFrame) {
        this.releaseBegin = startFrame;
        this.releaseEnd = endFrame;
    }

    public int getReleaseBegin() {
        return this.releaseBegin;
    }

    public int getReleaseEnd() {
        return this.releaseEnd;
    }

    public int getReleaseSize() {
        return this.releaseEnd - this.releaseBegin;
    }
}

