/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthFilter;
import com.softsynth.jsyn.SynthVariable;

public class Filter_2o2p2z
extends SynthFilter {
    public SynthVariable A0 = new SynthVariable(this, "A0");
    public SynthVariable A1 = new SynthVariable(this, "A1");
    public SynthVariable A2 = new SynthVariable(this, "A2");
    public SynthVariable B1 = new SynthVariable(this, "B1");
    public SynthVariable B2 = new SynthVariable(this, "B2");
    double omega = 0.0;
    double cs = 0.0;
    double sn = 0.0;
    double Q = 0.0;
    double alpha = 0.0;

    public Filter_2o2p2z(SynthContext synthContext, int calculationRate) throws SynthException {
        super(synthContext, "Filter_2o2p2z", calculationRate, 0);
    }

    public Filter_2o2p2z(SynthContext synthContext) throws SynthException {
        this(synthContext, 0);
    }

    public Filter_2o2p2z() throws SynthException {
        this(Synth.getSharedContext(), 0);
    }

    double sinh(double x) {
        return 0.5 * (Math.exp(x) - Math.exp(-x));
    }

    void calcCommon(double freq, double bandwidth) {
        double ratio = freq / this.context.getFrameRate();
        if (ratio >= 0.499) {
            ratio = 0.499;
        }
        this.omega = Math.PI * 2 * ratio;
        this.cs = Math.cos(this.omega);
        this.sn = Math.sin(this.omega);
        this.Q = this.sn / (Math.log(2.0) * bandwidth * this.omega);
        this.alpha = this.sn * this.sinh(0.5 / this.Q);
    }

    public void lowPass(int time, double frequency, double bandwidth) throws SynthException {
        this.calcCommon(frequency, bandwidth);
        double scalar = 0.5 / (1.0 + this.alpha);
        double c1 = 1.0 - this.cs;
        double A0_A2_Value = c1 * 0.5 * scalar;
        this.A0.set(time, A0_A2_Value);
        this.A1.set(time, c1 * scalar);
        this.A2.set(time, A0_A2_Value);
        this.B1.set(time, -2.0 * this.cs * scalar);
        this.B2.set(time, (1.0 - this.alpha) * scalar);
    }

    public void lowPass(double frequency, double bandwidth) throws SynthException {
        this.lowPass(this.context.getTickCount(), frequency, bandwidth);
    }

    public void highPass(int time, double frequency, double bandwidth) throws SynthException {
        this.calcCommon(frequency, bandwidth);
        double onePlusAlpha = 1.0 + this.alpha;
        double scalar = 0.5 / onePlusAlpha;
        double ct = 1.0 + this.cs;
        double A0_A2_Value = ct * 0.5 * scalar;
        this.A0.set(time, A0_A2_Value);
        this.A1.set(time, -ct * scalar);
        this.A2.set(time, A0_A2_Value);
        this.B1.set(time, -2.0 * this.cs * scalar);
        this.B2.set(time, (1.0 - this.alpha) * scalar);
    }

    public void highPass(double frequency, double bandwidth) throws SynthException {
        this.highPass(this.context.getTickCount(), frequency, bandwidth);
    }

    public void bandPass(int time, double frequency, double bandwidth) throws SynthException {
        this.calcCommon(frequency, bandwidth);
        double scalar = 0.5 / (1.0 + this.alpha);
        this.A0.set(time, this.alpha * scalar);
        this.A1.set(time, 0.0);
        this.A2.set(time, -this.alpha * scalar);
        this.B1.set(time, -2.0 * this.cs * scalar);
        this.B2.set(time, (1.0 - this.alpha) * scalar);
    }

    public void bandPass(double frequency, double bandwidth) throws SynthException {
        this.bandPass(this.context.getTickCount(), frequency, bandwidth);
    }

    public void notch(int time, double frequency, double bandwidth) throws SynthException {
        this.calcCommon(frequency, bandwidth);
        double scalar = 0.5 / (1.0 + this.alpha);
        double A1_B1_Value = -2.0 * this.cs * scalar;
        this.A0.set(time, scalar);
        this.A1.set(time, A1_B1_Value);
        this.A2.set(time, scalar);
        this.B1.set(time, A1_B1_Value);
        this.B2.set(time, (1.0 - this.alpha) * scalar);
    }

    public void notch(double frequency, double bandwidth) throws SynthException {
        this.notch(this.context.getTickCount(), frequency, bandwidth);
    }

    double calcA(double dBGain) {
        return Math.pow(10.0, dBGain / 40.0);
    }

    public void peakingEQ(int time, double frequency, double bandwidth, double dBGain) throws SynthException {
        this.calcCommon(frequency, bandwidth);
        double A = this.calcA(dBGain);
        double alphaTimesA = this.alpha * A;
        double alphaOverA = this.alpha / A;
        double scalar = 0.5 / (1.0 + alphaOverA);
        double A1_B1_Value = -2.0 * this.cs * scalar;
        this.A0.set(time, (1.0 + alphaTimesA) * scalar);
        this.A1.set(time, A1_B1_Value);
        this.A2.set(time, (1.0 - alphaTimesA) * scalar);
        this.B1.set(time, A1_B1_Value);
        this.B2.set(time, (1.0 - alphaOverA) * scalar);
    }

    public void peakingEQ(double frequency, double bandwidth, double dBGain) throws SynthException {
        this.peakingEQ(this.context.getTickCount(), frequency, bandwidth, dBGain);
    }

    double calcBeta(double slope, double A) {
        double am1 = A - 1.0;
        double beta2 = (A * A + 1.0) / slope - am1 * am1;
        if (beta2 < 0.0) {
            return 0.0;
        }
        return Math.sqrt(beta2);
    }

    public void lowShelf(int time, double frequency, double dBGain, double slope) throws SynthException {
        double ratio = frequency / this.context.getFrameRate();
        if (ratio >= 0.499) {
            ratio = 0.499;
        }
        this.omega = Math.PI * 2 * ratio;
        this.cs = Math.cos(this.omega);
        this.sn = Math.sin(this.omega);
        double A = this.calcA(dBGain);
        double beta = this.calcBeta(slope, A);
        double beta_sn = beta * this.sn;
        double AP1 = A + 1.0;
        double AM1 = A - 1.0;
        double AP1cs = AP1 * this.cs;
        double AM1cs = AM1 * this.cs;
        double scalar = 0.5 / (AP1 + AM1cs + beta_sn);
        this.A0.set(time, A * (AP1 - AM1cs + beta_sn) * scalar);
        this.A1.set(time, 2.0 * A * (AM1 - AP1cs) * scalar);
        this.A2.set(time, A * (AP1 - AM1cs - beta_sn) * scalar);
        this.B1.set(time, -2.0 * (AM1 + AP1cs) * scalar);
        this.B2.set(time, (AP1 + AM1cs - beta_sn) * scalar);
    }

    public void lowShelf(double frequency, double dBGain, double slope) throws SynthException {
        this.lowShelf(this.context.getTickCount(), frequency, dBGain, slope);
    }

    public void lowShelf(double frequency, double bandwidth, double dBGain, double slope) throws SynthException {
        this.lowShelf(this.context.getTickCount(), frequency, dBGain, slope);
    }

    public void lowShelf(int time, double frequency, double bandwidth, double dBGain, double slope) throws SynthException {
        this.lowShelf(time, frequency, dBGain, slope);
    }

    public void highShelf(int time, double frequency, double dBGain, double slope) throws SynthException {
        double ratio = frequency / this.context.getFrameRate();
        if (ratio >= 0.499) {
            ratio = 0.499;
        }
        this.omega = Math.PI * 2 * ratio;
        this.cs = Math.cos(this.omega);
        this.sn = Math.sin(this.omega);
        double A = this.calcA(dBGain);
        double beta = this.calcBeta(slope, A);
        double beta_sn = beta * this.sn;
        double AP1 = A + 1.0;
        double AM1 = A - 1.0;
        double AP1cs = AP1 * this.cs;
        double AM1cs = AM1 * this.cs;
        double scalar = 0.5 / (AP1 - AM1cs + beta_sn);
        this.A0.set(time, A * (AP1 + AM1cs + beta_sn) * scalar);
        this.A1.set(time, -2.0 * A * (AM1 + AP1cs) * scalar);
        this.A2.set(time, A * (AP1 + AM1cs - beta_sn) * scalar);
        this.B1.set(time, 2.0 * (AM1 - AP1cs) * scalar);
        this.B2.set(time, (AP1 - AM1cs - beta_sn) * scalar);
    }

    public void highShelf(double frequency, double dBGain, double slope) throws SynthException {
        this.highShelf(this.context.getTickCount(), frequency, dBGain, slope);
    }

    public void highShelf(double frequency, double bandwidth, double dBGain, double slope) throws SynthException {
        this.highShelf(this.context.getTickCount(), frequency, dBGain, slope);
    }

    public void highShelf(int time, double frequency, double bandwidth, double dBGain, double slope) throws SynthException {
        this.highShelf(time, frequency, dBGain, slope);
    }
}

