/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;

public class Synth {
    public static final int VERSION = 154;
    public static final String copyright = "Copyright 2000-2007 Phil Burk, All Rights Reserved";
    static boolean useNativeSynth = false;
    private static SynthContext sharedContext;
    public static int openCount;
    public static final int SILENT = 0;
    public static final int TERSE = 1;
    public static final int VERBOSE = 2;
    public static int verbosity;
    public static final int RATE_AUDIO = 0;
    public static final int PRIORITY_LOW = 0;
    public static final int PRIORITY_MEDIUM = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int SIGNAL_TYPE_RAW_SIGNED = 0;
    public static final int SIGNAL_TYPE_RAW_UNSIGNED = 1;
    public static final int SIGNAL_TYPE_OSC_FREQ = 2;
    public static final int SIGNAL_TYPE_SAMPLE_RATE = 3;
    public static final int SIGNAL_TYPE_HALF_LIFE = 4;
    public static final int SIGNAL_TYPE_TIME = 5;
    public static final int SIGNAL_TYPE_SVF_FREQ = 6;
    public static final int SIGNAL_TYPE_FULL_RANGE = 7;
    public static final int NUM_SIGNAL_TYPES = 8;
    public static final int NO_DEVICE = -1;
    public static final int FLAG_NON_REAL_TIME = 4;
    public static final int FLAG_LOOP_IF_LAST = 8;
    public static final int FLAG_AUTO_STOP = 16;
    public static final int FLAG_ENABLE_INPUT = 32;
    public static final int FLAG_DISABLE_OUTPUT = 64;
    public static final int FLAG_SKIP_IF_OTHERS = 128;
    static final int JS_ERR_BASE = -200;
    static final int JS_ERR_CIRCUIT_CLOSED = -200;
    static final int JS_ERR_OBSOLETE = -201;
    static final int JS_ERR_EXPIRED = -202;
    static final int JS_ERR_OUT_OF_RANGE = -203;
    static final int JS_ERR_ENGINE_MISSING = -204;
    static final int JS_ERR_USER = -205;
    public static final int DEBUG_REPORT = 1;
    public static final int DEBUG_THREAD = 2;
    public static final int DEBUG_GET_ALLOCS = 5;
    public static int timeAdvance;
    public static final double DEFAULT_FRAME_RATE = 44100.0;

    static {
        openCount = 0;
        verbosity = 0;
        timeAdvance = 100;
    }

    public static int getVersion() {
        return 154;
    }

    public static SynthContext getSharedContext() {
        return sharedContext;
    }

    public static int debug() {
        return sharedContext.debug();
    }

    public static int debug(int command, int data) {
        return sharedContext.debug(command, data);
    }

    public static int getExpirationDate() {
        return 0;
    }

    public static double getUsage() {
        return sharedContext.getUsage();
    }

    public static int getObjectCount() {
        return sharedContext.getObjectCount();
    }

    public static int getFrameCount() {
        return sharedContext.getFrameCount();
    }

    public static int getTickCount() {
        return sharedContext.getTickCount();
    }

    public static int getFramesPerTick() {
        return sharedContext.getFramesPerTick();
    }

    public static double getFrameRate() {
        return sharedContext.getFrameRate();
    }

    public static double getTickRate() {
        return sharedContext.getTickRate();
    }

    public static void sleepUntilTick(int tick) throws SynthException {
        sharedContext.sleepUntilTick(tick);
    }

    public static void checkEngineErrors() throws SynthException {
        sharedContext.checkEngineErrors();
    }

    public static void sleepForTicks(int ticks) throws SynthException {
        sharedContext.sleepForTicks(ticks);
    }

    public static synchronized void startEngine(int flags, double frameRate) throws SynthException {
        Synth.initialize();
        Synth.start(flags, frameRate);
    }

    public static synchronized void start(int flags, double frameRate, int inputDeviceID, int numInputChannels, int outputDeviceID, int numOutputChannels) throws SynthException {
        sharedContext.start(flags, frameRate, inputDeviceID, numInputChannels, outputDeviceID, numOutputChannels);
    }

    public static synchronized void start(int flags, double frameRate) throws SynthException {
        sharedContext.start(flags, frameRate);
    }

    public static synchronized void start(int flags) throws SynthException {
        Synth.start(flags, 44100.0);
    }

    public static void startEngine(int flags) throws SynthException {
        Synth.startEngine(flags, 44100.0);
    }

    public static synchronized void stopEngine() throws SynthException {
        Synth.stop();
        Synth.terminate();
    }

    public static synchronized void stop() throws SynthException {
        sharedContext.stop();
    }

    public static void requestVersion(int requestedVersion) {
        String upgradeMessage = "This Java Applet or application requires JSyn version \"" + (double)requestedVersion / 10.0 + "\".\n" + "You have version \"" + 15.4 + "\" installed on your computer\n" + "As a result, it may not work properly.\n\n" + "Please download a free upgrade to the new version\n" + "of the JSyn plugin at:\n\n" + "    http://www.softsynth.com/jsyn/plugins/";
        if (requestedVersion > 154) {
            SynthAlert.showError(upgradeMessage);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static synchronized void initialize() throws SynthException {
        if (sharedContext == null) {
            sharedContext = Synth.createSynthContext();
        }
        sharedContext.setTrace(verbosity);
        sharedContext.initialize();
        openCount = sharedContext.getOpenCount();
    }

    public static SynthContext createSynthContext() {
        return new SynthContext(useNativeSynth);
    }

    public static synchronized void terminate() throws SynthException {
        sharedContext.terminate();
        openCount = sharedContext.getOpenCount();
    }

    public static String errorCodeToString(int errorCode) {
        if (errorCode <= -200) {
            switch (errorCode) {
                case -200: {
                    return "SynthCircuit already compiled.";
                }
                case -201: {
                    return "JSyn version mismatch. Download new version from www.softsynth.com.";
                }
                case -202: {
                    return "JSyn version EXPIRED! Download new version from www.softsynth.com.";
                }
                case -203: {
                    return "JSyn value out of range.";
                }
                case -204: {
                    return "Could not access JSyn synthesis engine.";
                }
                case -205: {
                    return " -";
                }
            }
            return "Unrecognized JSyn error.";
        }
        byte[] text = new byte[128];
        try {
            int len = SynthContext.errorCodeToText(errorCode, text, text.length);
            return new String(text, 0, 0, len);
        }
        catch (UnsatisfiedLinkError e) {
            return "JSyn error text unavailable because link failed.";
        }
    }

    public static int hashName(String name) {
        int len = name.length();
        int hash = 0;
        int shiftBy = 0;
        int i = 0;
        while (i < len) {
            char c = name.charAt(i);
            hash += c << shiftBy;
            if ((shiftBy += 3) > 19) {
                shiftBy -= 20;
            }
            ++i;
        }
        return hash;
    }

    public static void setTrace(int mask) {
        verbosity = mask;
        if (sharedContext != null) {
            sharedContext.setTrace(mask);
        }
    }

    public static int getTrace() {
        return sharedContext.getTrace();
    }
}

