/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthSound;
import java.util.Enumeration;
import java.util.Vector;

public class SynthDistributor
extends SynthInput {
    SynthOutput driver;
    int outIndex;
    Vector connected = new Vector();
    int signalType = 7;
    double lastValue;

    public SynthDistributor(SynthSound sound, String name, int signalType) throws SynthException {
        super(sound, name);
        this.setSignalType(signalType);
    }

    public SynthDistributor(String name, int signalType) throws SynthException {
        this(null, name, signalType);
    }

    public SynthDistributor(SynthSound sound, String name) throws SynthException {
        this(sound, name, 7);
    }

    public SynthDistributor(String name) throws SynthException {
        this(null, name, 7);
    }

    public void connect(SynthInput inPort, int inIndex) throws SynthException {
        SDRec dr = null;
        Enumeration e = this.connected.elements();
        while (e.hasMoreElements()) {
            dr = (SDRec)e.nextElement();
            if (dr.port == inPort && dr.partNum == inIndex) {
                System.err.println("SynthDistributor already connected!");
                break;
            }
            dr = null;
        }
        inPort.setSignalType(this.signalType);
        inPort.set(this.lastValue);
        if (this.driver != null) {
            inPort.connect(inIndex, this.driver, this.outIndex);
        }
        if (dr == null) {
            dr = new SDRec(inPort, inIndex);
            this.connected.addElement(dr);
        }
    }

    @Override
    public void connect(int partNum, SynthInput inPort, int inIndex) throws SynthException {
        if (partNum > 0) {
            throw new SynthException(-203, "SynthDistributor part = " + partNum);
        }
        this.connect(inPort, inIndex);
    }

    public void connect(SynthOutput outPort, int outIndex) throws SynthException {
        this.driver = outPort;
        this.outIndex = outIndex;
        Enumeration e = this.connected.elements();
        while (e.hasMoreElements()) {
            SDRec dr = (SDRec)e.nextElement();
            dr.port.connect(dr.partNum, this.driver, outIndex);
        }
    }

    @Override
    public void connect(int inIndex, SynthOutput outPort, int outIndex) throws SynthException {
        if (inIndex > 0) {
            throw new SynthException(-203, "SynthDistributor part = " + inIndex);
        }
        this.connect(outPort, outIndex);
    }

    @Override
    public void disconnect() throws SynthException {
        this.disconnect(0);
    }

    @Override
    public void disconnect(int index) throws SynthException {
        Enumeration e = this.connected.elements();
        while (e.hasMoreElements()) {
            SDRec dr = (SDRec)e.nextElement();
            dr.port.disconnect(dr.partNum);
        }
        this.driver = null;
        this.outIndex = 0;
    }

    public void disconnect(SynthInput inPort, int inIndex) throws SynthException {
        Enumeration e = this.connected.elements();
        while (e.hasMoreElements()) {
            SDRec dr = (SDRec)e.nextElement();
            if (dr.port != inPort || dr.partNum != inIndex) continue;
            this.connected.removeElement(dr);
            if (this.driver == null) break;
            inPort.disconnect(inIndex);
            break;
        }
    }

    public void disconnect(SynthInput inPort) throws SynthException {
        this.disconnect(inPort, 0);
    }

    @Override
    public void set(int time, double value, int partIndex) throws SynthException {
        this.lastValue = value;
        Enumeration e = this.connected.elements();
        while (e.hasMoreElements()) {
            SDRec dr = (SDRec)e.nextElement();
            dr.port.set(time, value, partIndex);
        }
    }

    @Override
    public void set(double value, int partIndex) throws SynthException {
        this.lastValue = value;
        Enumeration e = this.connected.elements();
        while (e.hasMoreElements()) {
            SDRec dr = (SDRec)e.nextElement();
            dr.port.set(value, partIndex);
        }
    }

    @Override
    public void setSignalType(int signalType, int partIndex) throws SynthException {
        this.signalType = signalType;
        this.setMinMaxByType(signalType);
        Enumeration e = this.connected.elements();
        while (e.hasMoreElements()) {
            SDRec dr = (SDRec)e.nextElement();
            dr.port.setSignalType(signalType, partIndex);
        }
    }

    @Override
    public int getSignalType(int partIndex) throws SynthException {
        return this.signalType;
    }

    @Override
    public double get(int partIndex) throws SynthException {
        if (this.driver != null) {
            return this.driver.get(partIndex);
        }
        return this.lastValue;
    }

    @Override
    public double get() throws SynthException {
        return this.get(0);
    }

    @Override
    public int getNumParts() throws SynthException {
        return 1;
    }

    class SDRec {
        SynthInput port;
        int partNum;

        SDRec(SynthInput port, int partNum) {
            this.port = port;
            this.partNum = partNum;
        }
    }
}

