/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;

public class SynthMixer
extends SynthCircuit {
    int numInputs;
    int numOutputs;
    MultiplyAddUnit[][] nodes;

    public SynthMixer(int numInputs, int numOutputs) throws SynthException {
        this(Synth.getSharedContext(), numInputs, numOutputs);
    }

    public SynthMixer(SynthContext synthContext, int numInputs, int numOutputs) throws SynthException {
        this.numInputs = numInputs;
        this.numOutputs = numOutputs;
        this.nodes = new MultiplyAddUnit[numInputs][numOutputs];
        int j = 0;
        while (j < numOutputs) {
            int i = 0;
            while (i < numInputs) {
                MultiplyAddUnit multiplyAddUnit = new MultiplyAddUnit(synthContext);
                this.nodes[i][j] = multiplyAddUnit;
                this.add(multiplyAddUnit);
                if (i > 0) {
                    this.nodes[i - 1][j].output.connect(this.nodes[i][j].inputC);
                }
                ++i;
            }
            ++j;
        }
    }

    public void connectInput(int inputIndex, SynthOutput port, int partNum) throws SynthException {
        int i = 0;
        while (i < this.numOutputs) {
            MultiplyAddUnit node = this.nodes[inputIndex][i];
            port.connect(partNum, node.inputA, 0);
            ++i;
        }
    }

    public SynthOutput getOutput(int outputIndex) {
        return this.nodes[this.numInputs - 1][outputIndex].output;
    }

    public void connectOutput(int outputIndex, SynthInput port, int partNum) throws SynthException {
        MultiplyAddUnit node = this.nodes[this.numInputs - 1][outputIndex];
        node.output.connect(0, port, partNum);
    }

    public void setGain(int inputIndex, int outputIndex, double gain) throws SynthException {
        MultiplyAddUnit node = this.nodes[inputIndex][outputIndex];
        node.inputB.set(gain);
    }

    public void setGain(int time, int inputIndex, int outputIndex, double gain) throws SynthException {
        MultiplyAddUnit node = this.nodes[inputIndex][outputIndex];
        node.inputB.set(time, gain);
    }
}

