/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.EnvelopeCircuit;
import com.softsynth.jsyn.SawtoothOscillator;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.SawtoothOscillatorDPW;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SquareOscillator;
import com.softsynth.jsyn.SquareOscillatorBL;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthSound;
import com.softsynth.jsyn.TriangleOscillator;
import junit.framework.TestCase;

public class TestBenchmarks
extends TestCase {
    public double machineSpeed = 0.6;
    private boolean firstTime = true;

    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void checkBenchmark(Class<?> clazz, double maxPercentage) {
        try {
            int ticks = 2000;
            SynthSound[] units = new SynthSound[128];
            int i = 0;
            while (i < units.length) {
                units[i] = (SynthSound)clazz.newInstance();
                units[i].start();
                ++i;
            }
            long startTime = System.nanoTime();
            Synth.sleepForTicks(ticks);
            long stopTime = System.nanoTime();
            double elapsedTime = (double)(stopTime - startTime) * 1.0E-9;
            double audioTime = (double)ticks / Synth.getTickRate();
            double percentageRealTime = 100.0 * elapsedTime / audioTime;
            double adjustedPercentage = this.machineSpeed * percentageRealTime;
            if (this.firstTime) {
                System.out.format("ticks = %d,  audioTime = %f, numUnits = %d\n", ticks, audioTime, units.length);
                this.firstTime = false;
            }
            System.out.format("%40s, %8.5f secs, %8.5f%% real-time, %8.5f%% adjusted\n", clazz.getName(), elapsedTime, percentageRealTime, adjustedPercentage);
            TestBenchmarks.assertTrue("time too high, " + clazz.getName(), adjustedPercentage < maxPercentage);
            int i2 = 0;
            while (i2 < units.length) {
                units[i2].stop();
                ++i2;
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void testPerformance() {
        this.checkBenchmark(EnvelopeCircuit.class, 21.0);
        this.checkBenchmark(SineOscillator.class, 13.0);
        this.checkBenchmark(SawtoothOscillator.class, 4.5);
        this.checkBenchmark(SawtoothOscillatorBL.class, 32.0);
        this.checkBenchmark(SawtoothOscillatorDPW.class, 8.0);
        this.checkBenchmark(SquareOscillator.class, 5.0);
        this.checkBenchmark(SquareOscillatorBL.class, 50.0);
        this.checkBenchmark(TriangleOscillator.class, 50.0);
    }
}

