/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.ImpulseOscillator;
import com.softsynth.jsyn.InterpolatingDelayUnit;
import com.softsynth.jsyn.SignalChecker;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import junit.framework.TestCase;

public class TestInterpDelay
extends TestCase {
    private static final int SAMPLE_SIZE = 64;

    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void testDelay() {
        short[] sArray = new short[64];
        sArray[18] = 11469;
        sArray[19] = 4915;
        sArray[31] = 11469;
        sArray[32] = 4915;
        sArray[43] = 11469;
        sArray[44] = 4915;
        sArray[56] = 11469;
        sArray[57] = 4915;
        short[] image = sArray;
        DelayWithImpulse circuit1 = new DelayWithImpulse(Synth.getSharedContext());
        DelayWithImpulse circuit2 = new DelayWithImpulse(Synth.getSharedContext());
        this.check(circuit1, circuit2, image);
    }

    private void check(DelayWithImpulse circuit1, DelayWithImpulse circuit2, short[] image) {
        SignalChecker checker = new SignalChecker(Synth.getSharedContext());
        if (image == null) {
            image = new short[64];
            circuit2.start();
            checker.record(circuit2.output, image);
            checker.dumpSource(image);
        }
        circuit1.start();
        checker.compare(circuit1.output, image);
    }

    class DelayWithImpulse
    extends SynthCircuit {
        ImpulseOscillator unitOsc;
        InterpolatingDelayUnit unitDelay;
        SynthOutput output;

        public DelayWithImpulse(SynthContext synthContext) throws SynthException {
            super(synthContext);
            this.unitOsc = new ImpulseOscillator(synthContext);
            this.add(this.unitOsc);
            this.unitDelay = new InterpolatingDelayUnit(synthContext);
            this.add(this.unitDelay);
            this.output = this.unitDelay.output;
            this.addPort(this.output);
            this.unitOsc.frequency.set(3456.0);
            this.unitOsc.amplitude.set(0.5);
            this.unitOsc.output.connect(this.unitDelay.input);
            this.unitDelay.delay.set(12.3 / Synth.getFrameRate());
            this.compile();
        }
    }
}

