/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.ImpulseOscillator;
import com.softsynth.jsyn.PulseOscillator;
import com.softsynth.jsyn.SawtoothOscillator;
import com.softsynth.jsyn.SawtoothOscillatorDPW;
import com.softsynth.jsyn.SignalChecker;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SquareOscillator;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthUnit;
import com.softsynth.jsyn.TriangleOscillator;
import junit.framework.TestCase;

public class TestOscillators
extends TestCase {
    private static final int SAMPLE_SIZE = 200;
    SynthContext context;

    @Override
    protected void setUp() throws Exception {
        this.context = new SynthContext();
        this.context.initialize();
        this.context.start(4);
    }

    @Override
    protected void tearDown() throws Exception {
        this.context.stop();
    }

    public void testSine() {
        short[] imageSine = new short[]{2053, 4098, 6126, 8131, 10103, 12036, 13922, 15753, 17522, 19222, 20847, 22390, 23845, 25206, 26468, 27626, 28676, 29613, 30433, 31134, 31713, 32167, 32495, 32695, Short.MAX_VALUE, 32710, 32524, 32211, 31771, 31206, 30519, 29712, 28788, 27751, 26605, 25354, 24004, 22560, 21026, 19411, 17719, 15957, 14133, 12253, 10325, 8357, 6355, 4329, 2286, 233, -1819, -3865, -5896, -7903, -9880, -11818, -13709, -15547, -17323, -19032, -20665, -22218, -23683, -25055, -26329, -27499, -28561, -29511, -30345, -31060, -31653, -32121, -32463, -32678, -32764, -32722, -32551, -32252, -31826, -31276, -30602, -29808, -28898, -27873, -26739, -25500, -24161, -22727, -21204, -19597, -17914, -16160, -14342, -12468, -10545, -8581, -6583, -4559, -2517, -466, 1587, 3634, 5667, 7678, 9658, 11601, 13498, 15342, 17126, 18842, 20485, 22047, 23522, 24905, 26190, 27372, 28447, 29410, 30257, 30986, 31592, 32075, 32432, 32661, 32762, 32734, 32578, 32293, 31882, 31345, 30686, 29906, 29008, 27996, 26875, 25647, 24319, 22896, 21382, 19785, 18110, 16363, 14553, 12685, 10767, 8807, 6813, 4791, 2751, 700, -1352, -3401, -5436, -7450, -9434, -11381, -13284, -15134, -16925, -18650, -20301, -21872, -23358, -24752, -26048, -27242, -28329, -29305, -30166, -30908, -31529, -32025, -32397, -32640, -32756, -32743, -32601, -32331, -31934, -31412, -30766, -29999, -29115, -28116, -27006, -25791, -24474, -23061, -21558, -19969, -18303, -16564, -14760, -12899, -10986, -9031, -7040, -5021, -2983, -933};
        this.check(new SineOscillator(this.context), new SineOscillator(this.context), imageSine);
    }

    public void testSaw() {
        short[] imageSaw = new short[]{654, 1308, 1962, 2615, 3269, 3923, 4577, 5231, 5885, 6539, 7192, 7846, 8500, 9154, 9808, 10462, 11116, 11769, 12423, 13077, 13731, 14385, 15039, 15692, 16346, 17000, 17654, 18308, 18962, 19616, 20269, 20923, 21577, 22231, 22885, 23539, 24193, 24846, 25500, 26154, 26808, 27462, 28116, 28770, 29423, 30077, 30731, 31385, 32039, 32693, -32186, -31533, -30879, -30225, -29571, -28917, -28263, -27609, -26956, -26302, -25648, -24994, -24340, -23686, -23033, -22379, -21725, -21071, -20417, -19763, -19109, -18456, -17802, -17148, -16494, -15840, -15186, -14532, -13879, -13225, -12571, -11917, -11263, -10609, -9955, -9302, -8648, -7994, -7340, -6686, -6032, -5378, -4725, -4071, -3417, -2763, -2109, -1455, -801, -148, 505, 1159, 1813, 2467, 3121, 3774, 4428, 5082, 5736, 6390, 7044, 7698, 8351, 9005, 9659, 10313, 10967, 11621, 12275, 12928, 13582, 14236, 14890, 15544, 16198, 16852, 17505, 18159, 18813, 19467, 20121, 20775, 21429, 22082, 22736, 23390, 24044, 24698, 25352, 26006, 26659, 27313, 27967, 28621, 29275, 29929, 30582, 31236, 31890, 32544, -32335, -31681, -31027, -30374, -29720, -29066, -28412, -27758, -27104, -26450, -25797, -25143, -24489, -23835, -23181, -22527, -21873, -21220, -20566, -19912, -19258, -18604, -17950, -17296, -16643, -15989, -15335, -14681, -14027, -13373, -12720, -12066, -11412, -10758, -10104, -9450, -8796, -8143, -7489, -6835, -6181, -5527, -4873, -4219, -3566, -2912, -2258, -1604, -950, -296};
        this.check(new SawtoothOscillator(this.context), new SawtoothOscillator(this.context), imageSaw);
    }

    public void testSawDPW() {
        short[] imageSawDPW = new short[]{163, 654, 1308, 1962, 2615, 3269, 3923, 4577, 5231, 5885, 6539, 7192, 7846, 8500, 9154, 9808, 10462, 11116, 11769, 12423, 13077, 13731, 14385, 15039, 15692, 16346, 17000, 17654, 18308, 18962, 19616, 20269, 20923, 21577, 22231, 22885, 23539, 24193, 24846, 25500, 26154, 26808, 27462, 28116, 28770, 29423, 30077, 30731, 31385, 32039, 3650, -28462, -31533, -30879, -30225, -29571, -28917, -28263, -27609, -26956, -26302, -25648, -24994, -24340, -23686, -23032, -22379, -21725, -21071, -20417, -19763, -19109, -18456, -17802, -17148, -16494, -15840, -15186, -14532, -13879, -13225, -12571, -11917, -11263, -10609, -9955, -9302, -8648, -7994, -7340, -6686, -6032, -5378, -4725, -4071, -3417, -2763, -2109, -1455, -801, -148, 505, 1159, 1813, 2467, 3121, 3774, 4428, 5082, 5736, 6390, 7044, 7698, 8351, 9005, 9659, 10313, 10967, 11621, 12275, 12928, 13582, 14236, 14890, 15544, 16198, 16852, 17505, 18159, 18813, 19467, 20121, 20775, 21429, 22082, 22736, 23390, 24044, 24698, 25352, 26005, 26659, 27313, 27967, 28621, 29275, 29929, 30582, 31236, 31890, 10950, -21162, -31681, -31027, -30374, -29720, -29066, -28412, -27758, -27104, -26450, -25797, -25143, -24489, -23835, -23181, -22527, -21873, -21220, -20566, -19912, -19258, -18604, -17950, -17296, -16643, -15989, -15335, -14681, -14027, -13373, -12720, -12066, -11412, -10758, -10104, -9450, -8796, -8143, -7489, -6835, -6181, -5527, -4873, -4219, -3566, -2912, -2258, -1604, -950};
        this.check(new SawtoothOscillatorDPW(this.context), new SawtoothOscillatorDPW(this.context), imageSawDPW);
    }

    public void testSquare() {
        short[] imageSquare = new short[]{Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766};
        this.check(new SquareOscillator(this.context), new SquareOscillator(this.context), imageSquare);
    }

    public void testTriangle() {
        short[] imageTriangle = new short[]{1308, 2615, 3923, 5231, 6539, 7846, 9154, 10462, 11769, 13077, 14385, 15692, 17000, 18308, 19616, 20923, 22231, 23539, 24846, 26154, 27462, 28770, 30077, 31385, 32693, 31534, 30226, 28918, 27610, 26303, 24995, 23687, 22380, 21072, 19764, 18457, 17149, 15841, 14533, 13226, 11918, 10610, 9303, 7995, 6687, 5379, 4072, 2764, 1456, 149, -1158, -2466, -3774, -5081, -6389, -7697, -9004, -10312, -11620, -12927, -14235, -15543, -16851, -18158, -19466, -20774, -22081, -23389, -24697, -26005, -27312, -28620, -29928, -31235, -32543, -31681, -30374, -29066, -27758, -26450, -25143, -23835, -22527, -21220, -19912, -18604, -17296, -15989, -14681, -13373, -12066, -10758, -9450, -8143, -6835, -5527, -4219, -2912, -1604, -296, 1010, 2318, 3626, 4934, 6241, 7549, 8857, 10164, 11472, 12780, 14088, 15395, 16703, 18011, 19318, 20626, 21934, 23241, 24549, 25857, 27165, 28472, 29780, 31088, 32395, 31831, 30523, 29215, 27908, 26600, 25292, 23985, 22677, 21369, 20061, 18754, 17446, 16138, 14831, 13523, 12215, 10908, 9600, 8292, 6984, 5677, 4369, 3061, 1754, 446, -861, -2169, -3476, -4784, -6092, -7399, -8707, -10015, -11322, -12630, -13938, -15246, -16553, -17861, -19169, -20476, -21784, -23092, -24400, -25707, -27015, -28323, -29630, -30938, -32246, -31979, -30671, -29363, -28055, -26748, -25440, -24132, -22825, -21517, -20209, -18901, -17594, -16286, -14978, -13671, -12363, -11055, -9748, -8440, -7132, -5824, -4517, -3209, -1901, -594};
        this.check(new TriangleOscillator(this.context), new TriangleOscillator(this.context), imageTriangle);
    }

    public void testTriangleAboveNyquist() {
        short[] imageTriangle = new short[]{-21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430, -21429, 21430};
        TriangleOscillator osc1 = new TriangleOscillator(this.context);
        TriangleOscillator osc2 = new TriangleOscillator(this.context);
        osc1.frequency.set(57000.0);
        osc1.phase.set(0.173);
        osc2.frequency.set(57000.0);
        osc2.phase.set(0.173);
        this.check(osc1, osc2, imageTriangle);
    }

    public void testImpulse() {
        short[] sArray = new short[200];
        sArray[50] = Short.MAX_VALUE;
        sArray[150] = Short.MAX_VALUE;
        short[] imageImpulse = sArray;
        this.check(new ImpulseOscillator(this.context), new ImpulseOscillator(this.context), imageImpulse);
    }

    public void testPulse() {
        short[] imagePulse = new short[]{Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766, -32766};
        this.check(new PulseOscillator(this.context), new PulseOscillator(this.context), imagePulse);
    }

    private void check(SynthUnit unit1, SynthUnit unit2, short[] image) {
        SignalChecker checker = new SignalChecker(this.context);
        checker.checkUnits(unit1, unit2, image, 200);
    }
}

