/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.SampleReader_16F2;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.SampleWriter_16F2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import junit.framework.TestCase;

public class TestSample
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void testReadWriteMono() {
        short[] sArray = new short[9];
        sArray[0] = 123;
        sArray[1] = 456;
        sArray[2] = -789;
        sArray[3] = 111;
        sArray[4] = 20000;
        sArray[5] = Short.MIN_VALUE;
        sArray[6] = Short.MAX_VALUE;
        sArray[8] = 9876;
        short[] data = sArray;
        SynthSample sample = new SynthSample(data.length);
        TestSample.assertEquals("Sample numFrames", data.length, sample.getNumFrames());
        sample.write(data);
        short[] buffer = new short[data.length];
        sample.read(buffer);
        int i = 0;
        while (i < data.length) {
            TestSample.assertEquals("read = write", data[i], buffer[i]);
            ++i;
        }
        short[] partial = new short[]{333, 444, 555, 666, 777};
        sample.write(2, partial, 1, 3);
        sample.read(1, buffer, 1, 5);
        int i2 = 0;
        while (i2 < data.length) {
            if (i2 >= 2 && i2 <= 4) {
                TestSample.assertEquals("partial", partial[i2 - 1], buffer[i2]);
            } else {
                TestSample.assertEquals("read = write", data[i2], buffer[i2]);
            }
            ++i2;
        }
    }

    public void testReadWriteStereo() {
        short[] data = new short[]{100, 200, 300, 400, 500, 600, 700, 800, 900, 1000};
        int numFrames = data.length / 2;
        SynthSample sample = new SynthSample(numFrames, 2);
        TestSample.assertEquals("Sample numFrames", numFrames, sample.getNumFrames());
        sample.write(data);
        short[] buffer = new short[data.length];
        sample.read(buffer);
        int i = 0;
        while (i < data.length) {
            TestSample.assertEquals("read = write", data[i], buffer[i]);
            ++i;
        }
        short[] partial = new short[]{333, 444, 555, 666, 777, 888};
        sample.write(1, partial, 2, 2);
        sample.read(buffer);
        int i2 = 0;
        while (i2 < data.length) {
            if (i2 >= 2 && i2 <= 5) {
                TestSample.assertEquals("partial", partial[i2], buffer[i2]);
            } else {
                TestSample.assertEquals("read = write", data[i2], buffer[i2]);
            }
            ++i2;
        }
    }

    public void testEmptyPlayer() {
        SampleReader_16F1 reader = new SampleReader_16F1();
        reader.start();
        Synth.sleepForTicks(1);
        TestSample.assertEquals("no frames read from empty queue", 0, reader.samplePort.getNumFramesMoved());
    }

    public void testPlayRecord() {
        MonoSampleTester tester = new MonoSampleTester(3);
        tester.reader.samplePort.queueLoop(tester.source);
        tester.writer.samplePort.queue(tester.destination);
        int numTicks = 3;
        Synth.sleepForTicks(numTicks);
        short[] buffer = new short[tester.destination.getNumFrames()];
        tester.destination.read(buffer);
        int i = 0;
        while (i < buffer.length) {
            int k = i % tester.data.length;
            TestSample.assertEquals("read = write[" + i + "]", (double)tester.data[k], (double)buffer[i], 2.0);
            ++i;
        }
        TestSample.assertEquals("frames read", Synth.getFramesPerTick() * numTicks, tester.reader.samplePort.getNumFramesMoved());
        TestSample.assertEquals("frames written", buffer.length, tester.writer.samplePort.getNumFramesMoved());
    }

    public void testStereoPlayRecord() {
        StereoSampleTester tester = new StereoSampleTester(3);
        tester.reader.samplePort.queue(tester.source);
        tester.writer.samplePort.queue(tester.destination);
        Synth.sleepForTicks(2);
        short[] buffer = new short[tester.destination.getNumFrames() * 2];
        tester.destination.read(buffer);
        int i = 0;
        while (i < tester.source.getNumFrames() * 2) {
            TestSample.assertEquals("read = write[" + i + "]", (double)tester.data[i], (double)buffer[i], 2.0);
            ++i;
        }
        TestSample.assertEquals("frames read", tester.source.getNumFrames(), tester.reader.samplePort.getNumFramesMoved());
        TestSample.assertEquals("frames written", tester.destination.getNumFrames(), tester.writer.samplePort.getNumFramesMoved());
    }

    public void testSkipIfOthers() {
        MonoSampleTester tester = new MonoSampleTester(3);
        tester.reader.samplePort.queue(tester.source, 0, 2, 0);
        tester.reader.samplePort.queue(tester.source, 2, 2, 0);
        tester.reader.samplePort.queue(tester.source, 4, 2, 0);
        tester.writer.samplePort.queue(tester.destination);
        Synth.sleepForTicks(1);
        short[] buffer = new short[tester.destination.getNumFrames()];
        tester.destination.read(buffer);
        TestSample.assertEquals("unskipped data", (double)tester.data[0], (double)buffer[0], 2.0);
        TestSample.assertEquals("unskipped data", (double)tester.data[1], (double)buffer[1], 2.0);
        TestSample.assertEquals("unskipped data", (double)tester.data[2], (double)buffer[2], 2.0);
        TestSample.assertEquals("unskipped data", (double)tester.data[3], (double)buffer[3], 2.0);
        TestSample.assertEquals("unskipped data", (double)tester.data[4], (double)buffer[4], 2.0);
        TestSample.assertEquals("unskipped data", (double)tester.data[5], (double)buffer[5], 2.0);
        TestSample.assertEquals("frames read", 6, tester.reader.samplePort.getNumFramesMoved());
        tester = new MonoSampleTester(3);
        tester.reader.samplePort.queue(tester.source, 0, 2, 0);
        tester.reader.samplePort.queue(tester.source, 2, 2, 128);
        tester.reader.samplePort.queue(tester.source, 4, 2, 0);
        tester.writer.samplePort.queue(tester.destination);
        Synth.sleepForTicks(1);
        buffer = new short[tester.destination.getNumFrames()];
        tester.destination.read(buffer);
        TestSample.assertEquals("unskipped data", (double)tester.data[0], (double)buffer[0], 2.0);
        TestSample.assertEquals("unskipped data", (double)tester.data[1], (double)buffer[1], 2.0);
        TestSample.assertEquals("unskipped data", (double)tester.data[4], (double)buffer[2], 2.0);
        TestSample.assertEquals("unskipped data", (double)tester.data[5], (double)buffer[3], 2.0);
        TestSample.assertEquals("frames read", 4, tester.reader.samplePort.getNumFramesMoved());
    }

    public void checkClearWholeQueue(boolean scheduledClear) {
        MonoSampleTester tester = new MonoSampleTester(1000);
        int time = Synth.getTickCount();
        int numCopies = Synth.getFramesPerTick() / tester.data.length + 4;
        int j = 0;
        while (j < numCopies) {
            tester.reader.samplePort.queue(time, tester.source);
            ++j;
        }
        tester.writer.samplePort.queue(time, tester.destination);
        if (scheduledClear) {
            tester.reader.samplePort.clear(time + 1);
            Synth.sleepForTicks(2);
        } else {
            Synth.sleepForTicks(1);
            tester.reader.samplePort.clear();
            Synth.sleepForTicks(1);
        }
        short[] buffer = new short[tester.destination.getNumFrames()];
        tester.destination.read(buffer);
        int index = 0;
        int i = 0;
        while (i < Synth.getFramesPerTick()) {
            int k = index % tester.data.length;
            TestSample.assertEquals("read = write[" + index + "]", (double)tester.data[k], (double)buffer[index], 2.0);
            ++index;
            ++i;
        }
        i = 0;
        while (i < Synth.getFramesPerTick()) {
            TestSample.assertEquals("after clear", 0.0, (double)buffer[index], 1.0);
            ++index;
            ++i;
        }
    }

    public void testClearNow() {
        this.checkClearWholeQueue(false);
    }

    public void testScheduledClear() {
        this.checkClearWholeQueue(true);
    }

    public void testDelete() {
        short[] sArray = new short[9];
        sArray[0] = 123;
        sArray[1] = 456;
        sArray[2] = -789;
        sArray[3] = 111;
        sArray[4] = 20000;
        sArray[5] = Short.MIN_VALUE;
        sArray[6] = Short.MAX_VALUE;
        sArray[8] = 9876;
        short[] data = sArray;
        SynthSample sample = new SynthSample(data.length);
        TestSample.assertEquals("Sample numFrames", data.length, sample.getNumFrames());
        sample.write(data);
        sample.delete();
        boolean wrote = false;
        try {
            sample.write(data);
            wrote = true;
        }
        catch (Throwable thr) {
            System.out.println("Successfully caught: " + thr);
        }
        TestSample.assertEquals("Should not be able to write() after delete().", false, wrote);
    }

    public void testStereoSampleOnMonoPlayer() {
        short[] sArray = new short[8];
        sArray[0] = 123;
        sArray[1] = 456;
        sArray[2] = -789;
        sArray[3] = 111;
        sArray[4] = 20000;
        sArray[5] = Short.MIN_VALUE;
        sArray[6] = Short.MAX_VALUE;
        short[] data = sArray;
        SynthSample sample = new SynthSample(data.length, 2);
        sample.write(data);
        SampleReader_16F1 reader = new SampleReader_16F1();
        reader.start();
        try {
            reader.samplePort.queue(sample);
            TestSample.assertTrue("Should not get here. Should throw exception.", false);
        }
        catch (SynthException exc) {
            System.out.println("Successfully caught: " + exc);
            TestSample.assertTrue("Should catch exception for channel mismatch.", exc.getMessage().contains("ChannelsPerFrame mismatch"));
        }
        Synth.sleepForTicks(2);
        reader.stop();
    }

    public void testMonoSampleOnStereoPlayer() {
        short[] sArray = new short[9];
        sArray[0] = 123;
        sArray[1] = 456;
        sArray[2] = -789;
        sArray[3] = 111;
        sArray[4] = 20000;
        sArray[5] = Short.MIN_VALUE;
        sArray[6] = Short.MAX_VALUE;
        sArray[8] = 9876;
        short[] data = sArray;
        TestSample.assertEquals("data length should be odd to trigger exception", 1, data.length & 1);
        SynthSample sample = new SynthSample(data.length);
        sample.write(data);
        SampleReader_16F2 reader = new SampleReader_16F2();
        reader.start();
        try {
            reader.samplePort.queue(sample);
            TestSample.assertTrue("Should not get here. Should throw exception.", false);
        }
        catch (SynthException exc) {
            System.out.println("Successfully caught: " + exc);
            TestSample.assertTrue("Should catch exception for channel mismatch.", exc.getMessage().contains("ChannelsPerFrame mismatch"));
        }
        Synth.sleepForTicks(2);
        reader.stop();
    }

    class MonoSampleTester {
        short[] data;
        SynthSample source;
        SynthSample destination;
        SampleReader_16F1 reader;
        SampleWriter_16F1 writer;

        MonoSampleTester(int destMultiplier) {
            short[] sArray = new short[10];
            sArray[0] = 123;
            sArray[1] = 456;
            sArray[2] = -789;
            sArray[3] = 111;
            sArray[4] = 20000;
            sArray[5] = Short.MIN_VALUE;
            sArray[6] = Short.MAX_VALUE;
            sArray[8] = 9876;
            sArray[9] = -5432;
            this.data = sArray;
            this.source = new SynthSample(this.data.length);
            this.source.write(this.data);
            this.reader = new SampleReader_16F1();
            this.destination = new SynthSample(this.data.length * destMultiplier);
            this.writer = new SampleWriter_16F1();
            this.reader.output.connect(0, this.writer.input, 0);
            this.reader.start();
            this.writer.start();
        }
    }

    class StereoSampleTester {
        short[] data = new short[]{100, 200, 300, 400, 500, 600, 700, 800, 900, 1000};
        SynthSample source;
        SynthSample destination;
        SampleReader_16F2 reader;
        SampleWriter_16F2 writer;

        StereoSampleTester(int destMultiplier) {
            int numFrames = this.data.length / 2;
            this.source = new SynthSample(numFrames, 2);
            this.source.write(this.data);
            this.reader = new SampleReader_16F2();
            this.destination = new SynthSample(numFrames * destMultiplier, 2);
            this.writer = new SampleWriter_16F2();
            this.reader.output.connect(0, this.writer.input, 0);
            this.reader.output.connect(1, this.writer.input, 1);
            this.reader.start();
            this.writer.start();
        }
    }
}

