/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Filter_HighShelf;
import com.softsynth.jsyn.Filter_LowShelf;
import com.softsynth.jsyn.ImpulseOscillator;
import com.softsynth.jsyn.SignalChecker;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthFilter;
import junit.framework.TestCase;

public class TestShelfFilters
extends TestCase {
    private static final int SAMPLE_SIZE = 128;
    private static final double FILTER_FREQ = 1000.0;
    private static final double FILTER_GAIN = 1.5;
    private static final double OSC_FREQ = 900.0;
    static SynthContext context;

    @Override
    protected void setUp() throws Exception {
        context = new SynthContext();
        context.initialize();
        context.start(4);
    }

    @Override
    protected void tearDown() throws Exception {
        context.stop();
    }

    public void testLowShelf() {
        short[] sArray = new short[128];
        sArray[24] = 16722;
        sArray[25] = 676;
        sArray[26] = 673;
        sArray[27] = 659;
        sArray[28] = 638;
        sArray[29] = 611;
        sArray[30] = 579;
        sArray[31] = 544;
        sArray[32] = 506;
        sArray[33] = 467;
        sArray[34] = 427;
        sArray[35] = 387;
        sArray[36] = 349;
        sArray[37] = 311;
        sArray[38] = 275;
        sArray[39] = 240;
        sArray[40] = 208;
        sArray[41] = 178;
        sArray[42] = 150;
        sArray[43] = 125;
        sArray[44] = 102;
        sArray[45] = 81;
        sArray[46] = 63;
        sArray[47] = 46;
        sArray[48] = 32;
        sArray[49] = 19;
        sArray[50] = 9;
        sArray[52] = -7;
        sArray[53] = -13;
        sArray[54] = -18;
        sArray[55] = -22;
        sArray[56] = -25;
        sArray[57] = -27;
        sArray[58] = -28;
        sArray[59] = -28;
        sArray[60] = -28;
        sArray[61] = -28;
        sArray[62] = -27;
        sArray[63] = -26;
        sArray[64] = -25;
        sArray[65] = -23;
        sArray[66] = -22;
        sArray[67] = -20;
        sArray[68] = -18;
        sArray[69] = -17;
        sArray[70] = -15;
        sArray[71] = -13;
        sArray[72] = -12;
        sArray[73] = 16711;
        sArray[74] = 666;
        sArray[75] = 664;
        sArray[76] = 652;
        sArray[77] = 632;
        sArray[78] = 606;
        sArray[79] = 575;
        sArray[80] = 541;
        sArray[81] = 504;
        sArray[82] = 465;
        sArray[83] = 426;
        sArray[84] = 387;
        sArray[85] = 348;
        sArray[86] = 311;
        sArray[87] = 275;
        sArray[88] = 241;
        sArray[89] = 209;
        sArray[90] = 179;
        sArray[91] = 152;
        sArray[92] = 126;
        sArray[93] = 103;
        sArray[94] = 82;
        sArray[95] = 64;
        sArray[96] = 47;
        sArray[97] = 33;
        sArray[98] = 20;
        sArray[99] = 10;
        sArray[100] = 1;
        sArray[101] = -6;
        sArray[102] = -12;
        sArray[103] = -17;
        sArray[104] = -21;
        sArray[105] = -24;
        sArray[106] = -26;
        sArray[107] = -27;
        sArray[108] = -28;
        sArray[109] = -28;
        sArray[110] = -28;
        sArray[111] = -27;
        sArray[112] = -26;
        sArray[113] = -25;
        sArray[114] = -23;
        sArray[115] = -22;
        sArray[116] = -20;
        sArray[117] = -18;
        sArray[118] = -17;
        sArray[119] = -15;
        sArray[120] = -13;
        sArray[121] = -12;
        sArray[122] = 16711;
        sArray[123] = 666;
        sArray[124] = 664;
        sArray[125] = 652;
        sArray[126] = 632;
        sArray[127] = 606;
        short[] imageLowShelf = sArray;
        Filter_LowShelf filter1 = new Filter_LowShelf(context);
        filter1.frequency.set(1000.0);
        filter1.gain.set(1.5);
        Filter_LowShelf filter2 = new Filter_LowShelf(context);
        filter2.frequency.set(1000.0);
        filter2.gain.set(1.5);
        this.check(filter1, filter2, imageLowShelf);
    }

    public void testHighShelf() {
        short[] sArray = new short[128];
        sArray[24] = 24080;
        sArray[25] = -973;
        sArray[26] = -928;
        sArray[27] = -872;
        sArray[28] = -807;
        sArray[29] = -737;
        sArray[30] = -665;
        sArray[31] = -593;
        sArray[32] = -521;
        sArray[33] = -452;
        sArray[34] = -387;
        sArray[35] = -326;
        sArray[36] = -270;
        sArray[37] = -220;
        sArray[38] = -174;
        sArray[39] = -134;
        sArray[40] = -98;
        sArray[41] = -68;
        sArray[42] = -42;
        sArray[43] = -20;
        sArray[44] = -2;
        sArray[45] = 11;
        sArray[46] = 22;
        sArray[47] = 31;
        sArray[48] = 37;
        sArray[49] = 41;
        sArray[50] = 43;
        sArray[51] = 44;
        sArray[52] = 44;
        sArray[53] = 43;
        sArray[54] = 41;
        sArray[55] = 38;
        sArray[56] = 36;
        sArray[57] = 33;
        sArray[58] = 29;
        sArray[59] = 26;
        sArray[60] = 23;
        sArray[61] = 20;
        sArray[62] = 17;
        sArray[63] = 15;
        sArray[64] = 12;
        sArray[65] = 10;
        sArray[66] = 8;
        sArray[67] = 6;
        sArray[68] = 4;
        sArray[69] = 3;
        sArray[70] = 2;
        sArray[71] = 1;
        sArray[73] = 24079;
        sArray[74] = -974;
        sArray[75] = -929;
        sArray[76] = -873;
        sArray[77] = -809;
        sArray[78] = -739;
        sArray[79] = -667;
        sArray[80] = -594;
        sArray[81] = -523;
        sArray[82] = -454;
        sArray[83] = -389;
        sArray[84] = -328;
        sArray[85] = -272;
        sArray[86] = -221;
        sArray[87] = -175;
        sArray[88] = -135;
        sArray[89] = -99;
        sArray[90] = -69;
        sArray[91] = -42;
        sArray[92] = -21;
        sArray[93] = -3;
        sArray[94] = 11;
        sArray[95] = 22;
        sArray[96] = 31;
        sArray[97] = 37;
        sArray[98] = 41;
        sArray[99] = 43;
        sArray[100] = 44;
        sArray[101] = 44;
        sArray[102] = 43;
        sArray[103] = 41;
        sArray[104] = 38;
        sArray[105] = 36;
        sArray[106] = 33;
        sArray[107] = 29;
        sArray[108] = 26;
        sArray[109] = 23;
        sArray[110] = 20;
        sArray[111] = 17;
        sArray[112] = 15;
        sArray[113] = 12;
        sArray[114] = 10;
        sArray[115] = 8;
        sArray[116] = 6;
        sArray[117] = 4;
        sArray[118] = 3;
        sArray[119] = 2;
        sArray[120] = 1;
        sArray[122] = 24079;
        sArray[123] = -974;
        sArray[124] = -929;
        sArray[125] = -873;
        sArray[126] = -809;
        sArray[127] = -739;
        short[] imageHighShelf = sArray;
        Filter_HighShelf filter1 = new Filter_HighShelf(context);
        filter1.frequency.set(1000.0);
        filter1.gain.set(1.5);
        Filter_HighShelf filter2 = new Filter_HighShelf(context);
        filter2.frequency.set(1000.0);
        filter2.gain.set(1.5);
        this.check(filter1, filter2, imageHighShelf);
    }

    private void check(SynthFilter filter1, SynthFilter filter2, short[] image) {
        ImpulseOscillator osc = new ImpulseOscillator(context);
        osc.frequency.set(900.0);
        osc.amplitude.set(0.5);
        osc.start();
        osc.output.connect(filter1.input);
        SignalChecker checker = new SignalChecker(context);
        if (image == null) {
            osc.output.connect(filter2.input);
            osc.phase.set(0.0);
            image = new short[128];
            filter2.start();
            checker.record(filter2.output, image);
            checker.dumpSource(image);
        }
        filter1.start();
        osc.phase.set(0.0);
        checker.compare(filter1.output, image);
    }
}

