/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.Filter_StateVariable;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.WhiteNoise;

public class AnalogSnare
extends SynthNote {
    WhiteNoise myNoise = new WhiteNoise();
    Filter_StateVariable myFilter;
    ExponentialLag myLag;
    MultiplyUnit scaleLagToFreq;
    MultiplyUnit scaleLagToAmpl;
    AddUnit myMixer;
    public SynthInput noiseAmp;
    public SynthInput cutoff;
    public SynthInput resonance;

    public AnalogSnare() throws SynthException {
        this.add(this.myNoise);
        this.myFilter = new Filter_StateVariable();
        this.add(this.myFilter);
        this.myLag = new ExponentialLag();
        this.add(this.myLag);
        this.myMixer = new AddUnit();
        this.add(this.myMixer);
        this.scaleLagToFreq = new MultiplyUnit();
        this.add(this.scaleLagToFreq);
        this.scaleLagToAmpl = new MultiplyUnit();
        this.add(this.scaleLagToAmpl);
        this.myLag.output.connect(this.scaleLagToFreq.inputA);
        this.myLag.output.connect(this.scaleLagToAmpl.inputA);
        this.myLag.halfLife.set(0.1);
        this.scaleLagToFreq.output.connect(this.myFilter.frequency);
        this.scaleLagToAmpl.output.connect(this.myFilter.amplitude);
        this.myNoise.output.connect(this.myFilter.input);
        this.myFilter.output.connect(this.myMixer.inputA);
        this.noiseAmp = this.myNoise.amplitude;
        this.addPort(this.noiseAmp, "NoiseAmp");
        this.resonance = this.myFilter.resonance;
        this.addPort(this.resonance);
        this.frequency = this.scaleLagToFreq.inputB;
        this.addPort(this.frequency, "frequency");
        this.amplitude = this.scaleLagToAmpl.inputB;
        this.addPort(this.amplitude, "amplitude");
        this.output = this.myMixer.output;
        this.addPort(this.output);
        this.noiseAmp.setup(0.0, 0.3, 0.4);
        this.frequency.setup(0.0, 800.0, 1200.0);
        this.resonance.setup(0.0, 0.1, 0.2);
        this.amplitude.setup(0.0, 0.9, 0.999);
    }

    @Override
    public void setStage(int time, int stage) throws SynthException {
        switch (stage) {
            case 0: {
                this.stop(time);
                this.myLag.current.set(time, 1.0);
                this.start(time);
            }
        }
    }
}

