/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthSample;

class LongEcho
extends SynthCircuit {
    SynthSample delayLine;
    SampleReader_16F1 unitReader;
    SampleWriter_16F1 unitWriter;
    MultiplyAddUnit feedbackMixer;
    int numSamples;
    public SynthInput input;
    public SynthInput feedback;
    public SynthInput amplitude;

    public LongEcho(double delayTime) throws SynthException {
        this.numSamples = (int)(delayTime * Synth.getFrameRate());
        this.delayLine = new SynthSample(this.numSamples);
        this.unitReader = new SampleReader_16F1();
        this.add(this.unitReader);
        this.unitWriter = new SampleWriter_16F1();
        this.add(this.unitWriter);
        this.feedbackMixer = new MultiplyAddUnit();
        this.add(this.feedbackMixer);
        this.unitReader.samplePort.queue(this.delayLine, 30, this.numSamples - 30);
        this.unitReader.samplePort.queueLoop(this.delayLine, 0, this.numSamples);
        this.unitWriter.samplePort.queueLoop(this.delayLine, 0, this.numSamples);
        this.unitReader.output.connect(this.feedbackMixer.inputA);
        this.feedbackMixer.output.connect(this.unitWriter.input);
        this.input = this.feedbackMixer.inputC;
        this.addPort(this.input, "input");
        this.feedback = this.feedbackMixer.inputB;
        this.addPort(this.feedback, "feedback");
        this.amplitude = this.unitReader.amplitude;
        this.addPort(this.amplitude);
        this.output = this.unitReader.output;
        this.addPort(this.output);
    }
}

