/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.FilteredSawtoothBL;
import com.softsynth.jsyn.view102.SoundTester;
import com.softsynth.jsyn.view102.SynthScope;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;

public class SoundTestApplet
extends Applet {
    SynthCircuit circ;
    LineOut myOut;
    SynthScope scope;
    public boolean ifScope = true;

    public static void main(String[] args) {
        SoundTestApplet applet = new SoundTestApplet();
        AppletFrame frame = new AppletFrame("Test Circuit", applet);
        frame.resize(600, 500);
        frame.show();
        frame.test();
    }

    public SynthCircuit makeCircuit() throws SynthException {
        return new FilteredSawtoothBL();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.verbosity = 0;
            Synth.startEngine(0);
            this.circ = this.makeCircuit();
            this.myOut = new LineOut();
            this.add(new SoundTester(this.circ));
            if (this.circ.output != null) {
                this.circ.output.connect(0, this.myOut.input, 0);
                if (this.circ.output.getNumParts() > 1) {
                    this.circ.output.connect(1, this.myOut.input, 1);
                } else {
                    this.circ.output.connect(0, this.myOut.input, 1);
                }
                if (this.ifScope) {
                    this.scope = new SynthScope();
                    this.add(this.scope);
                    this.scope.createProbe(this.circ.output, "Circuit Output 0", Color.yellow);
                    if (this.circ.output.getNumParts() > 1) {
                        this.scope.createProbe(this.circ.output, 1, "Circuit Output 1", Color.green);
                    }
                    this.scope.finish();
                }
            }
            this.myOut.start();
            this.circ.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.myOut.delete();
            this.circ.delete();
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.err.println("Caught " + e);
            e.printStackTrace();
        }
    }
}

