/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleAIFF;
import com.softsynth.jsyn.SynthSampleWAV;
import com.softsynth.jsyn.view102.PortFader;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class TJ_Sample4
extends Applet {
    SynthSample sample;
    SynthSample sampleZero;
    SampleReader_16V1 samplePlayer;
    SynthEnvelope envelope;
    EnvelopePlayer envPlayer;
    LineOut myOut;
    Button startButton;
    Button stopButton;
    Button stopSmoothButton;
    Button testButton;
    Label messageLabel;
    boolean ifApplication = false;
    InputStream stream;
    final int NUM_FRAMES = 64;
    public String fileName = "samples/NotHereNow.wav";
    double rampUpTime = 0.0;
    double rampDownTime = 0.2;

    public static void main(String[] args) {
        TJ_Sample4 applet = new TJ_Sample4();
        if (args.length > 0) {
            applet.fileName = args[0];
        }
        applet.ifApplication = true;
        AppletFrame frame = new AppletFrame("Test SynthSample", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            try {
                if (this.ifApplication) {
                    this.stream = new FileInputStream(this.fileName);
                } else {
                    System.out.println("CodeBase = " + this.getCodeBase());
                    System.out.println("Path = " + this.getCodeBase());
                    URL sampleURL = new URL(this.getCodeBase(), this.fileName);
                    this.stream = sampleURL.openConnection().getInputStream();
                }
                switch (SynthSample.getFileType(this.fileName)) {
                    case 1: {
                        this.sample = new SynthSampleAIFF();
                        break;
                    }
                    case 2: {
                        this.sample = new SynthSampleWAV();
                        break;
                    }
                    default: {
                        SynthAlert.showError((Component)this, "Unrecognized sample file suffix.");
                    }
                }
                if (this.sample != null) {
                    this.loadSample(this.sample, this.stream);
                }
                this.stream.close();
            }
            catch (IOException e) {
                SynthAlert.showError((Component)this, e);
            }
            catch (SecurityException e) {
                SynthAlert.showError((Component)this, e);
            }
            this.samplePlayer = new SampleReader_16V1();
            short[] zeros = new short[4];
            this.sampleZero = new SynthSample(zeros.length, 1);
            this.sampleZero.write(zeros);
            this.envPlayer = new EnvelopePlayer();
            double[] data = new double[]{this.rampUpTime, 1.0, this.rampDownTime, 0.0};
            this.envelope = new SynthEnvelope(data);
            this.myOut = new LineOut();
            this.samplePlayer.output.connect(this.envPlayer.amplitude);
            this.envPlayer.output.connect(0, this.myOut.input, 0);
            this.envPlayer.output.connect(0, this.myOut.input, 1);
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(1, 0));
            this.add(panel);
            this.startButton = new Button("Start");
            panel.add(this.startButton);
            this.stopButton = new Button("Stop");
            panel.add(this.stopButton);
            this.stopSmoothButton = new Button("StopSmooth");
            panel.add(this.stopSmoothButton);
            this.testButton = new Button("TestOutput");
            panel.add(this.testButton);
            this.add(new PortFader(this.samplePlayer.amplitude, 0.7, 0.0, 1.0));
            this.messageLabel = new Label("  ");
            this.add(this.messageLabel);
            this.myOut.start();
            this.samplePlayer.start();
            this.envPlayer.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    public void loadSample(SynthSample sample, InputStream stream) throws IOException {
        sample.load(stream);
    }

    @Override
    public void stop() {
        try {
            this.envPlayer.delete();
            this.envPlayer = null;
            this.samplePlayer.delete();
            this.samplePlayer = null;
            this.myOut.delete();
            this.myOut = null;
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void showOutput() {
        double outVal = this.samplePlayer.output.get();
        this.messageLabel.setText("Output = " + outVal);
        this.repaint();
    }

    void startSample() {
        this.showOutput();
        this.samplePlayer.start();
        this.samplePlayer.samplePort.queue(this.sample);
        this.envPlayer.envelopePort.queue(this.envelope, 0, 1);
    }

    void stopSampleAbruptly() {
        this.showOutput();
        this.samplePlayer.samplePort.clear();
        this.envPlayer.envelopePort.clear();
    }

    void stopSampleSmoothly() {
        this.showOutput();
        int beginTime = Synth.getTickCount();
        int endTime = (beginTime += 2) + (int)(this.rampDownTime * Synth.getTickRate());
        this.envPlayer.envelopePort.queue(beginTime, this.envelope, 1, 1);
        this.samplePlayer.samplePort.clear(endTime);
        this.samplePlayer.samplePort.queue(endTime, this.sampleZero, 0, this.sampleZero.getNumFrames(), 16);
    }

    @Override
    public boolean action(Event evt, Object what) {
        block8: {
            block7: {
                block6: {
                    try {
                        if (evt.target != this.startButton) break block6;
                        this.startSample();
                        return true;
                    }
                    catch (SynthException e) {
                        SynthAlert.showError((Component)this, e);
                        return true;
                    }
                }
                if (evt.target != this.stopButton) break block7;
                this.stopSampleAbruptly();
                return true;
            }
            if (evt.target != this.stopSmoothButton) break block8;
            this.stopSampleSmoothly();
            return true;
        }
        if (evt.target == this.testButton) {
            this.showOutput();
            return true;
        }
        return false;
    }
}

