/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.TriangleOscillator;

public class Workshop1 {
    SawtoothOscillatorBL osc;
    LineOut lineOut;
    TriangleOscillator lfo;
    AddUnit adder;
    SynthInput frequency;

    public static void main(String[] args) {
        Workshop1 app = new Workshop1();
        app.test();
        System.exit(0);
    }

    public void test() {
        System.out.println("Play SawtoothBL");
        try {
            Synth.startEngine(0);
            this.osc = new SawtoothOscillatorBL();
            this.lineOut = new LineOut();
            this.lfo = new TriangleOscillator();
            this.adder = new AddUnit();
            this.frequency = this.adder.inputB;
            this.lfo.output.connect(this.adder.inputA);
            this.adder.output.connect(this.osc.frequency);
            this.osc.output.connect(0, this.lineOut.input, 0);
            this.osc.output.connect(0, this.lineOut.input, 1);
            this.lineOut.start();
            this.osc.start();
            this.adder.start();
            this.lfo.start();
            int duration = (int)(Synth.getTickRate() * 0.2);
            int advanceTime = (int)(Synth.getTickRate() * 0.5);
            int time = Synth.getTickCount() + advanceTime;
            double freq = 200.0;
            int i = 0;
            while (i < 10) {
                this.frequency.set(time, freq);
                this.lfo.frequency.set(time, Math.random() * 2.0);
                Synth.sleepUntilTick(time);
                freq *= 1.3333333333333333;
                time += duration;
                ++i;
            }
            this.osc.delete();
            this.lineOut.delete();
            this.lfo.delete();
            this.adder.delete();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError(e);
        }
        System.out.println("Finished.");
    }
}

