/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.perfrack;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthMixer;
import com.softsynth.jsyn.circuits.MultiTapDelay;
import com.softsynth.jsyn.examples.perfrack.BellPatternRackUnit;
import com.softsynth.jsyn.examples.perfrack.NoiseContourRackUnit;
import com.softsynth.jsyn.examples.perfrack.RackUnitMixControl;
import com.softsynth.jsyn.examples.perfrack.RackablePerformance;
import com.softsynth.jsyn.examples.perfrack.RecursiveMelodyRackUnit;
import com.softsynth.jsyn.view102.InsetPanel;
import com.softsynth.jsyn.view102.LabelledFader;
import com.softsynth.jsyn.view102.SynthScope;
import com.softsynth.jsyn.view102.Tweakable;
import com.softsynth.jsyn.view102.UsageDisplay;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Vector;

public class PerformanceRack
extends Applet
implements Runnable,
Tweakable {
    Vector bandMembers;
    LineOut unitOut;
    MultiTapDelay myReverb;
    SynthMixer mixer;
    int duration;
    SynthScope scope;
    Dialog scopeDialog;
    static final int TWEAK_INDEX_TEMPO = 0;
    GridBagConstraints constraint;
    GridBagLayout gridbag;
    Panel mixPanel;
    static int numStarts = 0;
    Object semaphore = new Object();
    boolean keepRunning = false;
    Thread mainThread = null;

    public static void main(String[] args) {
        PerformanceRack applet = new PerformanceRack();
        AppletFrame frame = new AppletFrame("PerformanceRack", applet);
        frame.resize(600, 550);
        frame.show();
        frame.test();
    }

    void makeTopControlPanel() {
        Panel topPanel = new Panel();
        this.constraint.weighty = 0.0;
        this.gridbag.setConstraints(topPanel, this.constraint);
        this.add(topPanel);
        Label aLabel = new Label("JSyn Rack #1");
        topPanel.add(aLabel);
        aLabel.setForeground(Color.red);
        Font smallFont = aLabel.getFont();
        Font bigFont = new Font(smallFont.getName(), 1, smallFont.getSize() * 2);
        if (bigFont != null) {
            aLabel.setFont(bigFont);
        }
        LabelledFader tempoFader = new LabelledFader(this, 0, "Tempo", 120.0, 60.0, 300.0);
        topPanel.add(tempoFader);
        tempoFader.getFader().resize(100, 30);
        topPanel.add("East", new UsageDisplay());
    }

    void makeMixControlPanel() {
        this.mixPanel = new Panel();
        this.mixPanel.setLayout(new GridLayout(0, 1));
        Panel mixLabelPanel = new Panel();
        this.mixPanel.add(mixLabelPanel);
        mixLabelPanel.setLayout(new GridLayout(1, 0));
        mixLabelPanel.add(new Label("RackUnit", 1));
        mixLabelPanel.add(new Label("Volume", 1));
        mixLabelPanel.add(new Label("Left/Right Pan", 1));
        mixLabelPanel.add(new Label("Echo Send", 1));
    }

    @Override
    public void start() {
        this.startSynth();
        this.mainThread = new Thread(this);
        this.keepRunning = true;
        this.mainThread.start();
    }

    @Override
    public void stop() {
        this.keepRunning = false;
        if (this.mainThread != null) {
            this.mainThread.interrupt();
            try {
                this.mainThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.stopSynth();
    }

    public void startSynth() throws SynthException {
        Synth.startEngine(0);
        this.duration = (int)(Synth.getTickRate() * 0.5);
        Synth.verbosity = 0;
        this.gridbag = new GridBagLayout();
        this.constraint = new GridBagConstraints();
        this.setLayout(this.gridbag);
        this.constraint.gridwidth = 0;
        this.constraint.fill = 1;
        this.constraint.weightx = 1.0;
        this.makeTopControlPanel();
        this.makeMixControlPanel();
        this.bandMembers = new Vector();
        this.bandMembers.addElement(new BellPatternRackUnit());
        this.bandMembers.addElement(new NoiseContourRackUnit());
        this.bandMembers.addElement(new RecursiveMelodyRackUnit());
        this.initBand();
        InsetPanel insetPanel = new InsetPanel((Component)this.mixPanel, 10);
        this.add(insetPanel);
        this.constraint.weighty = 0.0;
        this.constraint.gridheight = 0;
        this.gridbag.setConstraints(insetPanel, this.constraint);
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void initBand() throws SynthException {
        RackUnitMixControl mixTrack;
        int numBandMembers = this.bandMembers.size();
        this.mixer = new SynthMixer(numBandMembers + 1, 3);
        this.mixer.start();
        int i = 0;
        while (i < numBandMembers) {
            RackablePerformance riff = (RackablePerformance)this.bandMembers.elementAt(i);
            this.mixer.connectInput(i, riff.getOutput(), 0);
            mixTrack = new RackUnitMixControl(riff.getName(), this.mixer, i);
            this.mixPanel.add(mixTrack);
            mixTrack.setGain(1.0 / (double)this.bandMembers.size());
            mixTrack.setPan(0.5);
            mixTrack.setAuxSend(0.3);
            riff.start(Synth.getTickCount());
            InsetPanel insetPanel = new InsetPanel(riff.getUserInterface(), 10);
            insetPanel.setBackground((i & 1) == 0 ? Color.lightGray : Color.gray);
            this.add(insetPanel);
            this.constraint.weighty = riff.getNumRackUnits();
            System.out.println("units = " + riff.getNumRackUnits());
            this.gridbag.setConstraints(insetPanel, this.constraint);
            ++i;
        }
        this.unitOut = new LineOut();
        this.mixer.connectOutput(0, this.unitOut.input, 0);
        this.mixer.connectOutput(1, this.unitOut.input, 1);
        double[] delays = new double[]{0.457, 0.719, 0.901, 1.0, 1.17};
        double[] gains = new double[]{0.1, -0.3, -0.2, 0.1, 0.3};
        this.myReverb = new MultiTapDelay(delays, gains);
        this.mixer.connectOutput(2, this.myReverb.input, 0);
        this.mixer.connectInput(numBandMembers, this.myReverb.output, 0);
        mixTrack = new RackUnitMixControl("Echo Return", this.mixer, numBandMembers);
        this.mixPanel.add(mixTrack);
        mixTrack.setGain(1.0 / (double)numBandMembers);
        mixTrack.setPan(0.5);
        mixTrack.setAuxSend(0.0);
        this.myReverb.feedback.set(0.0);
        this.myReverb.start();
        this.unitOut.start();
    }

    public void stopSynth() throws SynthException {
        System.out.println("stopSynth() cleaning up.");
        this.stopBand();
        if (this.scopeDialog != null) {
            this.scopeDialog.hide();
        }
        this.removeAll();
        Synth.verbosity = 0;
        Synth.stopEngine();
    }

    void stopBand() throws SynthException {
        if (this.mixer != null) {
            this.mixer.stop();
        }
        if (this.bandMembers != null) {
            int i = 0;
            while (i < this.bandMembers.size()) {
                RackablePerformance riff = (RackablePerformance)this.bandMembers.elementAt(i);
                riff.stop(Synth.getTickCount());
                ++i;
            }
        }
        if (this.unitOut != null) {
            this.unitOut.stop();
        }
        if (this.myReverb != null) {
            this.myReverb.stop();
        }
    }

    @Override
    public void run() {
        System.out.println("run() - begin currentThread = " + Thread.currentThread());
        int beatIndex = 0;
        try {
            int advance = (int)(Synth.getTickRate() * 0.2);
            int now = Synth.getTickCount();
            while (this.keepRunning) {
                this.beat(now + advance, this.duration, beatIndex);
                ++beatIndex;
                Synth.sleepUntilTick(now += this.duration);
            }
        }
        catch (SynthException e) {
            System.out.println("run caught " + e);
        }
        System.out.println("run() - end currentThread = " + Thread.currentThread());
    }

    public void beat(int now, int duration, int beatIndex) throws SynthException {
        int i = 0;
        while (i < this.bandMembers.size()) {
            RackablePerformance riff = (RackablePerformance)this.bandMembers.elementAt(i);
            riff.beat(now, duration, beatIndex);
            ++i;
        }
    }

    @Override
    public void tweak(int index, double val) {
        switch (index) {
            case 0: {
                this.duration = (int)(Synth.getTickRate() * (60.0 / val));
            }
        }
    }
}

