/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.pinwheels;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.examples.pinwheels.PitchSpinner;
import com.softsynth.jsyn.examples.pinwheels.SpinnerThread;
import com.softsynth.jsyn.view102.InsetPanel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

public class PinWheels
extends Applet {
    PitchSpinner spinner;
    SpinnerThread spun;
    LineOut unitOut;

    public static void main(String[] args) {
        PinWheels applet = new PinWheels();
        AppletFrame frame = new AppletFrame("PinWheel", applet);
        frame.resize(550, 500);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        this.spinner = new PitchSpinner(8);
        this.add((Component)new InsetPanel((Component)this.spinner, Color.yellow), "Center");
        this.spinner.start();
        try {
            Synth.startEngine(0, 44100.0);
            this.unitOut = new LineOut();
            this.spun = new SpinnerThread(this.spinner);
            this.spun.allocator.output.connect(0, this.unitOut.input, 0);
            this.spun.allocator.output.connect(0, this.unitOut.input, 1);
            this.spun.start();
            this.unitOut.start();
            Synth.setTrace(0);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.spun.kill();
            this.spinner.stop();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.err.println("Caught " + e);
        }
    }
}

