/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.tuna;

import com.softsynth.jsyn.SynthBusInput;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.Swarm;
import com.softsynth.jsyn.examples.tuna.MelodicSequence;
import com.softsynth.jsyn.examples.tuna.TunaRiff;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Panel;

class TunaSwarm
extends TunaRiff {
    Swarm swarm;
    Checkbox timesBox2;
    Checkbox timesBox4;
    Checkbox timesBox8;

    public TunaSwarm(Panel panel, SynthBusInput bus, double ampl) throws SynthException {
        super(panel, "Swarm", bus, new Swarm(), ampl);
        this.swarm = (Swarm)this.unitNote;
        Panel timesPanel = new Panel();
        CheckboxGroup useGroup = new CheckboxGroup();
        this.timesBox2 = new Checkbox("*2", useGroup, false);
        timesPanel.add(this.timesBox2);
        this.timesBox4 = new Checkbox("*4", useGroup, true);
        timesPanel.add(this.timesBox4);
        this.timesBox8 = new Checkbox("*8", useGroup, false);
        timesPanel.add(this.timesBox8);
        panel.add(timesPanel);
    }

    @Override
    public boolean play(int time, MelodicSequence melody) throws SynthException {
        boolean ifChange = super.play(time, melody);
        if (this.playBox.getState()) {
            double interval = 1.0;
            if (this.timesBox2.getState()) {
                interval = 2.0;
            } else if (this.timesBox4.getState()) {
                interval = 4.0;
            } else if (this.timesBox8.getState()) {
                interval = 8.0;
            }
            int i = 0;
            while (i < melody.size()) {
                this.swarm.frequency.set(time, interval * melody.pitchAt(i));
                time += melody.durationAt(i);
                ++i;
            }
        }
        return ifChange;
    }
}

