/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;

public class QA_Connections {
    AddUnit adder1;
    AddUnit adder2;
    SynthDistributor dist;

    public static void main(String[] args) {
        QA_Connections app = new QA_Connections();
        app.test();
    }

    public void test() {
        int numErrors = 0;
        try {
            Synth.startEngine(4);
            Synth.stopEngine();
            System.out.println("NumErrors = " + (numErrors += this.testDistributor()));
        }
        catch (SynthException e) {
            SynthAlert.showError(e);
        }
    }

    int testDistributor() {
        int numErrors = 0;
        this.adder1 = new AddUnit();
        this.adder2 = new AddUnit();
        this.dist = new SynthDistributor("pass");
        this.adder1.start();
        this.adder2.start();
        this.adder1.output.connect(this.dist);
        this.dist.connect(this.adder2.inputA);
        numErrors += this.checkDistributor(0.3, "forward connection");
        this.dist.disconnect();
        this.adder1.output.connect(this.dist);
        numErrors += this.checkDistributor(0.7, "disconnected and reconnected driver");
        this.adder1 = new AddUnit();
        this.adder2 = new AddUnit();
        this.dist = new SynthDistributor("pass");
        this.adder1.start();
        this.adder2.start();
        this.adder1.output.connect(this.dist);
        this.dist.connect(this.adder2.inputA);
        numErrors += this.checkDistributor(0.1, "backward connection");
        this.dist.disconnect(this.adder2.inputA, 0);
        this.dist.connect(this.adder2.inputA);
        return numErrors += this.checkDistributor(0.5, "disconnected and reconnected sink");
    }

    int checkDistributor(double inVal, String msg) {
        this.adder1.inputA.set(inVal);
        Synth.sleepForTicks(10);
        double outVal = this.adder2.output.get();
        if (outVal < inVal * 0.99 || outVal > inVal * 1.01) {
            System.err.println("testDistributor, " + msg + " failed! outVal = " + outVal);
            return 1;
        }
        System.out.println("testDistributor, " + msg + " passed! outVal = " + outVal);
        return 0;
    }
}

