/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthTable;
import java.applet.Applet;
import java.awt.Component;

public class QA_Exceptions
extends Applet {
    SineOscillator sineOsc;
    SampleReader_16V1 sampler;
    boolean showAlerts = false;
    int numErrors = 0;

    public static void main(String[] args) {
        QA_Exceptions applet = new QA_Exceptions();
        AppletFrame frame = new AppletFrame("Test Exceptions", applet);
        frame.resize(600, 500);
        frame.show();
        frame.test();
    }

    void reportError(String msg) {
        System.err.println(msg);
        ++this.numErrors;
    }

    @Override
    public void start() {
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                try {
                                    Synth.startEngine(0);
                                    this.sineOsc = new SineOscillator();
                                    this.sampler = new SampleReader_16V1();
                                    this.sineOsc.output.connect(this.sampler.rate);
                                }
                                catch (SynthException e) {
                                    if (!this.showAlerts) break block12;
                                    SynthAlert.showError((Component)this, e);
                                }
                            }
                            try {
                                this.sineOsc.frequency.setSignalType(this.sampler.rate);
                                this.reportError("ERROR - Should have trapped setting signal type to unsigned.");
                            }
                            catch (SynthException e) {
                                if (!this.showAlerts) break block13;
                                SynthAlert.showError((Component)this, e);
                            }
                        }
                        try {
                            this.sineOsc.output.get(1);
                            this.reportError("ERROR - Should have trapped out of range get(1).");
                        }
                        catch (SynthException e) {
                            if (!this.showAlerts) break block14;
                            SynthAlert.showError((Component)this, e);
                        }
                    }
                    try {
                        this.sineOsc.output.get(-1);
                        this.reportError("ERROR - Should have trapped out of range get(-1).");
                    }
                    catch (SynthException e) {
                        if (!this.showAlerts) break block15;
                        SynthAlert.showError((Component)this, e);
                    }
                }
                try {
                    this.sineOsc.frequency.getSignalType(1);
                    this.reportError("ERROR - Should have trapped out of range getSignalType(1).");
                }
                catch (SynthException e) {
                    if (!this.showAlerts) break block16;
                    SynthAlert.showError((Component)this, e);
                }
            }
            try {
                this.sineOsc.frequency.getSignalType(-1);
                this.reportError("ERROR - Should have trapped out of range getSignalType(-1).");
            }
            catch (SynthException e) {
                if (!this.showAlerts) break block17;
                SynthAlert.showError((Component)this, e);
            }
        }
        this.testTableBounds();
        this.testSampleBounds();
        this.testEnvelopeBounds();
        System.out.println("Test complete. NumErrors = " + this.numErrors);
    }

    void testTableBounds() {
        block22: {
            double[] data;
            SynthTable table;
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    try {
                                        table = new SynthTable(-123);
                                        this.reportError("ERROR - Should have trapped creating a table with negative size.");
                                    }
                                    catch (SynthException e) {
                                        if (!this.showAlerts) break block16;
                                        SynthAlert.showError((Component)this, e);
                                    }
                                }
                                table = new SynthTable(8);
                                data = new double[]{0.12, 0.23, 0.34, 0.45, 0.56, 0.67};
                                try {
                                    System.out.println("try table.write( data );");
                                    table.write(data);
                                    System.out.println("try table.write( 2, data, 0, 6 );");
                                    table.write(2, data, 0, 6);
                                    System.out.println("try table.write( 4, data, 2, 4 );");
                                    table.write(4, data, 2, 4);
                                }
                                catch (SynthException e) {
                                    this.reportError("ERROR - Writing legally to table should have worked.");
                                }
                                try {
                                    table.write(-7, data, 0, 4);
                                    this.reportError("ERROR - Should have trapped writing a table with negative index.");
                                }
                                catch (SynthException e) {
                                    if (!this.showAlerts) break block17;
                                    SynthAlert.showError((Component)this, e);
                                }
                            }
                            try {
                                table.write(3, data, 0, 6);
                                this.reportError("ERROR - Should have trapped writing a table past end.");
                            }
                            catch (SynthException e) {
                                if (!this.showAlerts) break block18;
                                SynthAlert.showError((Component)this, e);
                            }
                        }
                        try {
                            table.write(0, data, 0, 9);
                            this.reportError("ERROR - Should have trapped writing more than we have data.");
                        }
                        catch (SynthException e) {
                            if (!this.showAlerts) break block19;
                            SynthAlert.showError((Component)this, e);
                        }
                    }
                    try {
                        table.write(0, data, 1, 6);
                        this.reportError("ERROR - Should have trapped writing more than we have data.");
                    }
                    catch (SynthException e) {
                        if (!this.showAlerts) break block20;
                        SynthAlert.showError((Component)this, e);
                    }
                }
                try {
                    table.write(0, data, -1, 2);
                    this.reportError("ERROR - Should have trapped writing from outside table.");
                }
                catch (SynthException e) {
                    if (!this.showAlerts) break block21;
                    SynthAlert.showError((Component)this, e);
                }
            }
            data = null;
            try {
                table.write(0, data, 0, 4);
                this.reportError("ERROR - Should have trapped writing NULL data.");
            }
            catch (Exception e) {
                if (!this.showAlerts) break block22;
                SynthAlert.showError((Component)this, e);
            }
        }
    }

    void testSampleBounds() {
        SynthSample sample;
        block5: {
            block4: {
                try {
                    sample = new SynthSample(-123);
                    this.reportError("ERROR - Should have trapped creating a sample with negative size.");
                }
                catch (SynthException e) {
                    if (!this.showAlerts) break block4;
                    SynthAlert.showError((Component)this, e);
                }
            }
            try {
                sample = new SynthSample(200, 3);
                this.reportError("ERROR - Should have trapped creating a sample with 3 channels.");
            }
            catch (SynthException e) {
                if (!this.showAlerts) break block5;
                SynthAlert.showError((Component)this, e);
            }
        }
        short[] data = new short[]{12, 23, 34, 45, 56, 67};
        sample = new SynthSample(8, 1);
        System.out.println("Try mono sample.");
        this.testSampleVarious(sample, data);
        sample = new SynthSample(8, 2);
        System.out.println("Try stereo sample.");
        this.testSampleVarious(sample, data);
    }

    void testSampleVarious(SynthSample sample, short[] data) {
        block37: {
            short[] nulldata;
            block36: {
                block35: {
                    int numDataFrames;
                    int numChannels;
                    block34: {
                        block33: {
                            int numFrames;
                            block32: {
                                block31: {
                                    block30: {
                                        block29: {
                                            block28: {
                                                block27: {
                                                    block26: {
                                                        numFrames = sample.getNumFrames();
                                                        numChannels = sample.getChannelsPerFrame();
                                                        int numData = data.length;
                                                        numDataFrames = numData / numChannels;
                                                        try {
                                                            sample.write(data);
                                                            sample.write(numFrames - numDataFrames, data, 0, numDataFrames);
                                                            sample.write(numFrames - numDataFrames + 2, data, 2 * numChannels, numDataFrames - 2);
                                                        }
                                                        catch (SynthException e) {
                                                            this.reportError("ERROR - Writing legally to sample should have worked.");
                                                        }
                                                        try {
                                                            sample.write(-7, data, 0, 4);
                                                            this.reportError("ERROR - Should have trapped writing a sample with negative index.");
                                                        }
                                                        catch (SynthException e) {
                                                            if (!this.showAlerts) break block26;
                                                            SynthAlert.showError((Component)this, e);
                                                        }
                                                    }
                                                    try {
                                                        sample.write(numFrames - numDataFrames + 1, data, 0, numDataFrames);
                                                        this.reportError("ERROR - Should have trapped writing a sample past end.");
                                                    }
                                                    catch (SynthException e) {
                                                        if (!this.showAlerts) break block27;
                                                        SynthAlert.showError((Component)this, e);
                                                    }
                                                }
                                                try {
                                                    sample.write(0, data, 0, numDataFrames + 1);
                                                    this.reportError("ERROR - Should have trapped writing more than we have data.");
                                                }
                                                catch (SynthException e) {
                                                    if (!this.showAlerts) break block28;
                                                    SynthAlert.showError((Component)this, e);
                                                }
                                            }
                                            try {
                                                sample.write(0, data, numChannels, numDataFrames);
                                                this.reportError("ERROR - Should have trapped writing more than we have data.");
                                            }
                                            catch (SynthException e) {
                                                if (!this.showAlerts) break block29;
                                                SynthAlert.showError((Component)this, e);
                                            }
                                        }
                                        try {
                                            sample.write(0, data, -1, 2);
                                            this.reportError("ERROR - Should have trapped writing from outside sample.");
                                        }
                                        catch (SynthException e) {
                                            if (!this.showAlerts) break block30;
                                            SynthAlert.showError((Component)this, e);
                                        }
                                    }
                                    nulldata = null;
                                    try {
                                        sample.write(2, nulldata, 0, 4);
                                        this.reportError("ERROR - Should have trapped writing NULL data.");
                                    }
                                    catch (Exception e) {
                                        if (!this.showAlerts) break block31;
                                        SynthAlert.showError((Component)this, e);
                                    }
                                }
                                try {
                                    sample.read(-7, data, 0, 4);
                                    this.reportError("ERROR - Should have trapped reading a sample with negative index.");
                                }
                                catch (SynthException e) {
                                    if (!this.showAlerts) break block32;
                                    SynthAlert.showError((Component)this, e);
                                }
                            }
                            try {
                                sample.read(numFrames - numDataFrames + 1, data, 0, numDataFrames);
                                this.reportError("ERROR - Should have trapped reading a sample past end.");
                            }
                            catch (SynthException e) {
                                if (!this.showAlerts) break block33;
                                SynthAlert.showError((Component)this, e);
                            }
                        }
                        try {
                            sample.read(0, data, 0, numDataFrames + 1);
                            this.reportError("ERROR - Should have trapped reading more than we have data.");
                        }
                        catch (SynthException e) {
                            if (!this.showAlerts) break block34;
                            SynthAlert.showError((Component)this, e);
                        }
                    }
                    try {
                        sample.read(0, data, numChannels, numDataFrames);
                        this.reportError("ERROR - Should have trapped reading more than we have data.");
                    }
                    catch (SynthException e) {
                        if (!this.showAlerts) break block35;
                        SynthAlert.showError((Component)this, e);
                    }
                }
                try {
                    sample.read(0, data, -1, 2);
                    this.reportError("ERROR - Should have trapped reading from outside sample.");
                }
                catch (SynthException e) {
                    if (!this.showAlerts) break block36;
                    SynthAlert.showError((Component)this, e);
                }
            }
            try {
                sample.read(2, nulldata, 0, 4);
                this.reportError("ERROR - Should have trapped reading NULL data.");
            }
            catch (Exception e) {
                if (!this.showAlerts) break block37;
                SynthAlert.showError((Component)this, e);
            }
        }
    }

    void testEnvelopeBounds() {
        block40: {
            double[] nulldata;
            SynthEnvelope envelope;
            block39: {
                double[] data;
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            try {
                                                                envelope = new SynthEnvelope(-123);
                                                                this.reportError("ERROR - Should have trapped creating a envelope with negative size.");
                                                            }
                                                            catch (SynthException e) {
                                                                if (!this.showAlerts) break block28;
                                                                SynthAlert.showError((Component)this, e);
                                                            }
                                                        }
                                                        envelope = new SynthEnvelope(8);
                                                        data = new double[]{0.1, 0.1, 0.1, 0.2, 0.1, 0.3, 0.1, 0.4, 0.1, 0.5, 0.1, 0.6};
                                                        try {
                                                            envelope.write(data);
                                                            envelope.write(2, data, 0, 6);
                                                            envelope.write(4, data, 2, 4);
                                                        }
                                                        catch (SynthException e) {
                                                            this.reportError("ERROR - Writing legally to envelope should have worked.");
                                                        }
                                                        try {
                                                            envelope.write(-7, data, 0, 4);
                                                            this.reportError("ERROR - Should have trapped writing a envelope with negative index.");
                                                        }
                                                        catch (SynthException e) {
                                                            if (!this.showAlerts) break block29;
                                                            SynthAlert.showError((Component)this, e);
                                                        }
                                                    }
                                                    try {
                                                        envelope.write(5, data, 0, 4);
                                                        this.reportError("ERROR - Should have trapped writing a envelope past end.");
                                                    }
                                                    catch (SynthException e) {
                                                        if (!this.showAlerts) break block30;
                                                        SynthAlert.showError((Component)this, e);
                                                    }
                                                }
                                                try {
                                                    envelope.write(0, data, 0, 7);
                                                    this.reportError("ERROR - Should have trapped writing more to envelope than we have data.");
                                                }
                                                catch (SynthException e) {
                                                    if (!this.showAlerts) break block31;
                                                    SynthAlert.showError((Component)this, e);
                                                }
                                            }
                                            try {
                                                envelope.write(0, data, 1, 6);
                                                this.reportError("ERROR - Should have trapped writing more to envelope than we have data.");
                                            }
                                            catch (SynthException e) {
                                                if (!this.showAlerts) break block32;
                                                SynthAlert.showError((Component)this, e);
                                            }
                                        }
                                        try {
                                            envelope.write(0, data, -1, 2);
                                            this.reportError("ERROR - Should have trapped writing from outside envelope.");
                                        }
                                        catch (SynthException e) {
                                            if (!this.showAlerts) break block33;
                                            SynthAlert.showError((Component)this, e);
                                        }
                                    }
                                    nulldata = null;
                                    try {
                                        envelope.write(2, nulldata, 0, 4);
                                        this.reportError("ERROR - Should have trapped writing NULL data to envelope.");
                                    }
                                    catch (Exception e) {
                                        if (!this.showAlerts) break block34;
                                        SynthAlert.showError((Component)this, e);
                                    }
                                }
                                try {
                                    envelope.read(-7, data, 0, 4);
                                    this.reportError("ERROR - Should have trapped reading an envelope with negative index.");
                                }
                                catch (SynthException e) {
                                    if (!this.showAlerts) break block35;
                                    SynthAlert.showError((Component)this, e);
                                }
                            }
                            try {
                                envelope.read(5, data, 0, 4);
                                this.reportError("ERROR - Should have trapped reading an envelope past end.");
                            }
                            catch (SynthException e) {
                                if (!this.showAlerts) break block36;
                                SynthAlert.showError((Component)this, e);
                            }
                        }
                        try {
                            envelope.read(0, data, 0, 7);
                            this.reportError("ERROR - Should have trapped reading more to envelope than we have data.");
                        }
                        catch (SynthException e) {
                            if (!this.showAlerts) break block37;
                            SynthAlert.showError((Component)this, e);
                        }
                    }
                    try {
                        envelope.read(0, data, 1, 6);
                        this.reportError("ERROR - Should have trapped reading more to envelope than we have data.");
                    }
                    catch (SynthException e) {
                        if (!this.showAlerts) break block38;
                        SynthAlert.showError((Component)this, e);
                    }
                }
                try {
                    envelope.read(0, data, -1, 2);
                    this.reportError("ERROR - Should have trapped reading from outside envelope.");
                }
                catch (SynthException e) {
                    if (!this.showAlerts) break block39;
                    SynthAlert.showError((Component)this, e);
                }
            }
            try {
                envelope.read(2, nulldata, 0, 4);
                this.reportError("ERROR - Should have trapped reading NULL data to envelope .");
            }
            catch (Exception e) {
                if (!this.showAlerts) break block40;
                SynthAlert.showError((Component)this, e);
            }
        }
    }

    @Override
    public void stop() {
        Synth.stopEngine();
    }
}

