/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.util.VoiceAllocator;
import java.util.Vector;

public abstract class BussedVoiceAllocator
extends VoiceAllocator {
    BusReader busReader;
    Vector writers = new Vector();
    public SynthOutput output;

    public BussedVoiceAllocator(SynthContext synthContext, int maxVoices) {
        super(synthContext, maxVoices);
        this.busReader = new BusReader(synthContext);
        this.output = this.busReader.output;
        this.busReader.setPriority(0);
        this.busReader.start();
    }

    public BussedVoiceAllocator(int maxVoices) {
        this(Synth.getSharedContext(), maxVoices);
    }

    public synchronized SynthCircuit addVoiceToMix(SynthCircuit circuit) throws SynthException {
        BusWriter busWriter = new BusWriter();
        this.writers.addElement(busWriter);
        circuit.output.connect(busWriter.input);
        busWriter.busOutput.connect(this.busReader.busInput);
        busWriter.start();
        return circuit;
    }

    public SynthOutput getOutput() {
        return this.busReader.output;
    }

    @Override
    public synchronized void delete() {
        super.delete();
        this.busReader.delete();
        this.output = null;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        while (!this.writers.isEmpty()) {
            BusWriter writer = (BusWriter)this.writers.lastElement();
            this.writers.removeElement(writer);
            writer.delete();
        }
    }
}

