/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;

public abstract class VoiceAllocator {
    static final int LONGTIME = 0x3FFFFFFF;
    SynthCircuit[] voices;
    int[] priorities;
    int[] stopTimes;
    int maxVoices;
    int numVoices = 0;
    SynthContext synthContext;

    public VoiceAllocator(SynthContext synthContext, int maxVoices) {
        this.maxVoices = maxVoices;
        this.synthContext = synthContext;
        this.voices = new SynthCircuit[maxVoices];
        this.priorities = new int[maxVoices];
        this.stopTimes = new int[maxVoices];
    }

    public VoiceAllocator(int maxVoices) {
        this(Synth.getSharedContext(), maxVoices);
    }

    public int getMaxVoices() {
        return this.maxVoices;
    }

    public int getNumVoices() {
        return this.numVoices;
    }

    public SynthCircuit getNthVoice(int index) {
        return this.voices[index];
    }

    public abstract SynthCircuit makeVoice() throws SynthException;

    synchronized SynthCircuit addVoice(int stopTime, int priority) throws SynthException {
        SynthCircuit circ;
        if (this.numVoices == this.maxVoices) {
            return null;
        }
        this.voices[this.numVoices] = circ = this.makeVoice();
        this.mark(this.numVoices, stopTime, priority);
        ++this.numVoices;
        return circ;
    }

    synchronized int searchEarliest(int startTime, int priority) {
        int minDelta = Integer.MAX_VALUE;
        int chosen = -1;
        int i = 0;
        while (i < this.numVoices) {
            int delta = this.stopTimes[i] - startTime;
            if ((priority >= this.priorities[i] || delta <= 0) && delta < minDelta) {
                minDelta = delta;
                chosen = i;
            }
            ++i;
        }
        return chosen;
    }

    void mark(int chosen, int stopTime, int priority) {
        this.stopTimes[chosen] = stopTime;
        this.priorities[chosen] = priority;
    }

    public synchronized SynthCircuit allocate(int startTime, int stopTime, int priority) throws SynthException {
        if (this.numVoices == 0) {
            return this.addVoice(stopTime, priority);
        }
        int chosen = this.searchEarliest(startTime, priority - 1);
        if (chosen >= 0) {
            this.mark(chosen, stopTime, priority);
            return this.voices[chosen];
        }
        if (this.numVoices < this.maxVoices) {
            return this.addVoice(stopTime, priority);
        }
        return null;
    }

    public synchronized SynthCircuit allocate(int startTime, int stopTime) throws SynthException {
        return this.allocate(startTime, stopTime, 0);
    }

    public synchronized SynthCircuit allocate(int startTime) throws SynthException {
        return this.allocate(startTime, startTime + 0x3FFFFFFF, 0);
    }

    public synchronized SynthCircuit allocate() throws SynthException {
        return this.allocate(this.synthContext.getTickCount());
    }

    public synchronized SynthCircuit steal(int startTime, int stopTime, int priority) throws SynthException {
        SynthCircuit circ = this.allocate(startTime, stopTime, priority);
        if (circ != null) {
            return circ;
        }
        int chosen = this.searchEarliest(startTime, priority);
        if (chosen >= 0) {
            if (Synth.verbosity >= 1) {
                System.out.println("VoiceAllocator: steal " + chosen);
            }
            this.mark(chosen, stopTime, priority);
            return this.voices[chosen];
        }
        return null;
    }

    public synchronized SynthCircuit steal(int startTime, int stopTime) throws SynthException {
        return this.steal(startTime, stopTime, 0);
    }

    public synchronized SynthCircuit steal(int startTime) throws SynthException {
        return this.steal(startTime, startTime + 0x3FFFFFFF, 0);
    }

    public SynthCircuit steal() throws SynthException {
        return this.steal(this.synthContext.getTickCount());
    }

    public synchronized void free(int stopTime, SynthCircuit circuit) {
        int i = 0;
        while (i < this.numVoices) {
            if (circuit == this.voices[i]) {
                this.mark(i, stopTime, 0);
                break;
            }
            ++i;
        }
    }

    public void free(SynthCircuit circuit) throws SynthException {
        this.free(this.synthContext.getTickCount(), circuit);
    }

    public void stop(int time) {
        int i = 0;
        while (i < this.numVoices) {
            this.voices[i].stop(time);
            ++i;
        }
    }

    public void stop() {
        this.stop(Synth.getTickCount());
    }

    public void delete() {
        this.clear();
    }

    public void clear() {
        int i = 0;
        while (i < this.numVoices) {
            this.voices[i].delete();
            this.voices[i] = null;
            ++i;
        }
        this.numVoices = 0;
    }
}

