/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.jsyn.SynthSound;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.view.PortFader;
import com.softsynth.jsyn.view.UsageDisplay;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class SoundTester
extends Panel {
    Checkbox[] cbox;
    SynthSound sound;
    Button hitButton;
    static final int NUM_STAGES = 8;

    public SoundTester(SynthSound sound) throws SynthException {
        this.sound = sound;
        this.setLayout(new GridLayout(0, 1));
        int numPorts = sound.getNumPorts();
        int i = 0;
        while (i < numPorts) {
            SynthPort newPort = sound.getPortAt(i);
            if (newPort instanceof SynthVariable) {
                this.addInput((SynthVariable)newPort);
            }
            ++i;
        }
        Panel stageSetter = new Panel();
        CheckboxGroup cbg = new CheckboxGroup();
        this.cbox = new Checkbox[8];
        stageSetter.add(new Label("Stage:"));
        int i2 = 0;
        while (i2 < 8) {
            this.cbox[i2] = new Checkbox(Integer.toString(i2), cbg, i2 == 0);
            stageSetter.add(this.cbox[i2]);
            ++i2;
        }
        this.add(stageSetter);
        this.hitButton = new Button("Hit");
        this.add(this.hitButton);
        this.add(new UsageDisplay());
    }

    void addInput(SynthVariable input) throws SynthException {
        this.add(new PortFader(input, input.get(), input.getMin(), input.getMax()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean action(Event evt, Object what) {
        try {
            int i = 0;
            while (true) {
                if (i >= 8) {
                    if (evt.target != this.hitButton) return false;
                    this.sound.setStage(0);
                    return true;
                }
                if (this.cbox[i] == evt.target) {
                    this.sound.setStage(i);
                    return true;
                }
                ++i;
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
            return true;
        }
    }
}

