/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

import com.softsynth.math.JustRatio;
import com.softsynth.math.PrimeFactors;
import junit.framework.TestCase;

public class TestPrimeFactor
extends TestCase {
    public void testPrimeSeries() {
        int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23};
        int i = 0;
        while (i < primes.length) {
            int p = primes[i];
            TestPrimeFactor.assertEquals("prime " + p, p, PrimeFactors.getPrime(i));
            ++i;
        }
    }

    public void checkFactors(int[] expected, int n) {
        int[] actual = PrimeFactors.factor(n);
        TestPrimeFactor.assertEquals("length", expected.length, actual.length);
        int i = 0;
        while (i < actual.length) {
            TestPrimeFactor.assertEquals("factor", expected[i], actual[i]);
            ++i;
        }
    }

    public void testFactors() {
        int[] f1 = new int[]{};
        this.checkFactors(f1, 1);
        int[] f2 = new int[]{1};
        this.checkFactors(f2, 2);
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] f3 = nArray;
        this.checkFactors(f3, 3);
        int[] f6 = new int[]{1, 1};
        this.checkFactors(f6, 6);
        int[] f12 = new int[]{2, 1};
        this.checkFactors(f12, 12);
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[2] = 2;
        int[] f50 = nArray2;
        this.checkFactors(f50, 50);
        int[] nArray3 = new int[4];
        nArray3[0] = 2;
        nArray3[3] = 1;
        int[] f28 = nArray3;
        this.checkFactors(f28, 28);
    }

    public void checkRatios(int[] expected, int n, int d) {
        PrimeFactors primeFactors = new PrimeFactors(n, d);
        int[] actual = primeFactors.getFactors();
        TestPrimeFactor.assertEquals("length", expected.length, actual.length);
        int i = 0;
        while (i < actual.length) {
            TestPrimeFactor.assertEquals("factor", expected[i], actual[i]);
            ++i;
        }
    }

    public void testRatios() {
        int[] f1 = new int[]{};
        this.checkRatios(f1, 1, 1);
        int[] f2 = new int[]{1};
        this.checkRatios(f2, 2, 1);
        int[] f1_2 = new int[]{-1};
        this.checkRatios(f1_2, 1, 2);
        int[] f4_3 = new int[]{2, -1};
        this.checkRatios(f4_3, 4, 3);
        this.checkRatios(f4_3, 8, 6);
        this.checkRatios(f4_3, 56, 42);
    }

    public void checkReduction(int n1, int d1, int n2, int d2) {
        PrimeFactors primeFactors = new PrimeFactors(n1, d1);
        JustRatio ratio = primeFactors.getJustRatio();
        TestPrimeFactor.assertEquals("numerator", (long)n2, ratio.numerator);
        TestPrimeFactor.assertEquals("denominator", (long)d2, ratio.denominator);
    }

    public void testReduction() {
        this.checkReduction(3, 2, 3, 2);
        this.checkReduction(6, 4, 3, 2);
        this.checkReduction(882, 588, 3, 2);
        this.checkReduction(2940, 2058, 10, 7);
    }

    public void testToString() {
        TestPrimeFactor.assertEquals("formatted output", "1/1", new PrimeFactors(1, 1).toString());
        TestPrimeFactor.assertEquals("formatted output", "7/5", new PrimeFactors(7, 5).toString());
        TestPrimeFactor.assertEquals("formatted output", "2*3/5", new PrimeFactors(6, 5).toString());
        TestPrimeFactor.assertEquals("formatted output", "2*3*3/5", new PrimeFactors(18, 5).toString());
        TestPrimeFactor.assertEquals("formatted output", "(5^4)/2*(3^3)", new PrimeFactors(625, 54).toString());
    }
}

