/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.tools.jsyn;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;

public class CheckForJSyn
extends Panel {
    public static final int AVAILABLE = 0;
    public static final int CLASSES_MISSING = -1;
    public static final int NATIVE_LIBRARY_MISSING = -2;
    public static final int OBSOLETE = -3;
    final Applet applet;

    public static void main(String[] args) {
        int status = CheckForJSyn.getStatus();
        if (status == 0) {
            System.out.println(CheckForJSyn.getStatusText(status));
        } else {
            System.err.println(CheckForJSyn.getStatusText(status));
        }
    }

    public CheckForJSyn(Applet applet) {
        this.applet = applet;
    }

    public CheckForJSyn setupGUI(int jsynStatus) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add("Center", new TextArea(CheckForJSyn.getStatusText(jsynStatus)));
        if (jsynStatus != 0) {
            Button getPluginButton = new Button("Get JSyn Plugin");
            this.add("South", getPluginButton);
            getPluginButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppletContext appletContext = CheckForJSyn.this.applet.getAppletContext();
                    try {
                        appletContext.showDocument(new URL("http://www.softsynth.com/jsyn/plugins/"));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            });
            this.validate();
        }
        return this;
    }

    public static String getStatusText(int status) {
        String text = null;
        switch (status) {
            case 0: {
                text = "JSyn is installed.";
                break;
            }
            case -1: {
                text = "JSyn classes missing. Plugin not installed. Please download the JSyn plugin from \"http://www.softsynth.com/jsyn/\".";
                break;
            }
            case -2: {
                text = "JSyn native library missing. Plugin partially installed.\nPlease reinstall the JSyn plugin from \"http://www.softsynth.com/jsyn/\".\nIf installation is unsuccessful visit \"http://www.softsynth.com/jsyn/support/\".";
                break;
            }
            case -3: {
                text = "A very old version of JSyn is installed and needs to be upgraded.\nPlease reinstall the JSyn plugin from \"http://www.softsynth.com/jsyn/\".";
                break;
            }
            default: {
                text = "CheckForJSyn.getStatus() returned unrecognized result = " + status;
            }
        }
        return text;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getStatus() {
        try {
            Class.forName("com.softsynth.jsyn.CuePoint");
            try {
                Class<?> cl = Class.forName("com.softsynth.jsyn.SynthContext");
                try {
                    Object obj = cl.newInstance();
                    return 0;
                }
                catch (Throwable thr) {
                    return -2;
                }
            }
            catch (Throwable thr) {
                return -3;
            }
        }
        catch (Throwable thr2) {
            return -1;
        }
    }
}

