/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.IndentingWriter;
import com.softsynth.util.XMLTools;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Stack;

public class XMLWriter
extends IndentingWriter {
    Stack tagStack = new Stack();
    boolean hasContent = false;

    public XMLWriter(OutputStream stream) {
        super(stream);
    }

    public XMLWriter(Writer outputStreamWriter) {
        super(outputStreamWriter);
    }

    public void writeAttribute(String name, String value) {
        this.print(" " + name + "=\"" + XMLTools.escapeText(value) + "\"");
    }

    public void writeAttribute(String name, int value) {
        this.writeAttribute(name, Integer.toString(value));
    }

    public void writeAttribute(String name, long value) {
        this.writeAttribute(name, Long.toString(value));
    }

    public void writeAttribute(String name, double value) {
        this.writeAttribute(name, Double.toString(value));
    }

    public void writeAttribute(String name, boolean value) {
        this.writeAttribute(name, value ? "1" : "0");
    }

    public void writeHeader() {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
    }

    public void startTag(String name) {
        this.beginTag(name);
    }

    public void beginTag(String name) {
        if (!this.hasContent && this.tagStack.size() > 0) {
            this.beginContent();
            this.println();
        }
        this.print("<" + name);
        this.tagStack.push(name);
        this.hasContent = false;
        this.indent();
    }

    public void endTag() {
        this.undent();
        String name = (String)this.tagStack.pop();
        if (this.hasContent) {
            this.println("</" + name + ">");
        } else {
            this.println(" />");
        }
        this.hasContent = !this.tagStack.isEmpty();
    }

    public void beginContent() {
        this.print(">");
        this.hasContent = true;
    }

    public void endContent() {
    }

    public void writeComment(String text) throws IOException {
        if (!this.hasContent && this.tagStack.size() > 0) {
            this.beginContent();
            this.println();
        }
        this.println("<!-- " + XMLTools.escapeText(text) + "-->");
    }

    public void writeContent(String string) {
        this.beginContent();
        this.print(XMLTools.escapeText(string));
        this.endContent();
    }

    public void writeTag(String tag, String content) {
        this.beginTag(tag);
        this.writeContent(content);
        this.endTag();
    }
}

