/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.util.TextOutput;
import com.softsynth.wire.LoaderContext;
import com.softsynth.wire.Module;
import com.softsynth.wire.ModuleLoader;
import com.softsynth.wire.Patch;
import com.softsynth.wire.WireJack;
import java.util.Hashtable;

class MiscLoader
extends ModuleLoader {
    String portName;
    double value;
    boolean contentIsComment = false;

    public MiscLoader(String tag, LoaderContext ldcon) {
        super(tag, ldcon);
    }

    WireJack handlePortAttributes(Hashtable attributes) {
        WireJack wPort = null;
        this.portName = (String)attributes.get("port");
        if (this.portName != null) {
            if (this.portName.equals("port")) {
                this.portName = this.currentModule.getName();
                TextOutput.println("FIXME - Converting port to " + this.portName);
            }
            if ((wPort = this.currentModule.getJack(this.portName, 0)) == null) {
                throw new RuntimeException("Couldn't find port " + this.portName);
            }
        }
        this.value = this.getAttribute(attributes, "value", 0.0);
        return wPort;
    }

    @Override
    public void handleBeginElement(String tag, Hashtable attributes) {
        if (tag.equals("comment")) {
            WireJack wPort = this.handlePortAttributes(attributes);
            this.contentIsComment = true;
        } else if (tag.equals("set")) {
            WireJack wPort = this.handlePortAttributes(attributes);
            wPort.set(this.value);
        } else if (tag.equals("min")) {
            WireJack wPort = this.handlePortAttributes(attributes);
            wPort.setMin(this.value);
        } else if (tag.equals("max")) {
            WireJack wPort = this.handlePortAttributes(attributes);
            wPort.setMax(this.value);
        } else {
            super.handleBeginElement(tag, attributes);
        }
    }

    @Override
    public void handleFoundContent(String content) {
        if (this.contentIsComment) {
            this.currentModule.setComment(content);
        }
        this.contentIsComment = false;
    }

    @Override
    Module makeModule(Patch patch) {
        return patch.addMisc(this.name, this.type);
    }
}

