/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSound;
import com.softsynth.util.IndentingWriter;
import com.softsynth.util.NumericOutput;
import com.softsynth.util.TextOutput;
import com.softsynth.view.MessageDialog;
import com.softsynth.wire.CircuitModule;
import com.softsynth.wire.GetTextDialog;
import com.softsynth.wire.InputPort;
import com.softsynth.wire.Module;
import com.softsynth.wire.ParameterizedUnitModule;
import com.softsynth.wire.PatchPanel;
import com.softsynth.wire.SampleModule;
import com.softsynth.wire.SaveAsStream;
import com.softsynth.wire.TopLoader;
import com.softsynth.wire.UnitModule;
import com.softsynth.wire.Wire;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class Patch
extends Module
implements KeyListener {
    Vector modules;
    static String defaultCircuitName = "com.softsynth.jsyn.circuits.FilteredSawtoothBL";
    Vector selected;
    static byte[] pasteBuffer = null;
    private PatchPanel patchPanel;
    private JPanel topPanel;
    JFrame frame;
    JLabel modifiedLabel;
    JButton upButton;
    JButton keyButton;
    JLabel faderLabel;
    MenuBar menuBar;
    Menu fileMenu;
    Menu viewMenu;
    Menu editMenu;
    Menu addMenu;
    String sourceDir = "patches";
    File saveFile = null;
    final File defaultSaveFile = new File("patches", "Untitled.xml");
    static File globalDefaultLoadFile = new File("patches", "Untitled.xml");
    File defaultLoadFile = null;
    String className = "TestCircuit";
    MessageDialog saveIfNeededDialog;
    int pasteOffset = 0;
    static Hashtable paramUnitRemaps;
    static String keyboard;
    ActionListener showParentActionListener;
    int lastKeyDown = -1;
    String tempType;

    static {
        keyboard = "zxcvbnmasdfghjqwertyu1234567";
        paramUnitRemaps = new Hashtable();
        paramUnitRemaps.put("DelayUnit", "DelayUnitModule");
        paramUnitRemaps.put("InterpolatingDelayUnit", "InterpDelayUnitModule");
    }

    public Patch() {
        this.modules = new Vector();
        this.selected = new Vector();
    }

    @Override
    public Rectangle getEditorBounds() {
        return this.frame.getBounds();
    }

    Rectangle fitToScreen(Rectangle rect) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (rect.x + rect.width > screenSize.width) {
            rect.x = screenSize.width - rect.width;
        }
        if (rect.x < 0) {
            rect.x = 0;
            rect.width = screenSize.width;
        }
        if (rect.y + rect.height > screenSize.height) {
            rect.y = screenSize.height - rect.height;
        }
        if (rect.y < 0) {
            rect.y = 0;
            rect.height = screenSize.height;
        }
        return rect;
    }

    @Override
    public void setEditorBounds(Rectangle rect) {
        this.frame.setBounds(this.fitToScreen(rect));
    }

    File getRecommendedSaveFile() {
        return this.saveFile == null ? this.defaultSaveFile : this.saveFile;
    }

    File getRecommendedLoadFile() {
        return this.defaultLoadFile == null ? globalDefaultLoadFile : this.defaultLoadFile;
    }

    void setRecommendedLoadFile(File file) {
        globalDefaultLoadFile = file;
        this.defaultLoadFile = file;
    }

    public PatchPanel getPatchPanel() {
        return this.patchPanel;
    }

    Module findModule(String name) {
        Module module = null;
        Enumeration enumer = this.modules.elements();
        while (enumer.hasMoreElements()) {
            Module tempModule = (Module)enumer.nextElement();
            if (!tempModule.getName().equals(name)) continue;
            module = tempModule;
            break;
        }
        return module;
    }

    @Override
    public void setModified(boolean flag) {
        boolean old = this.getModified();
        super.setModified(flag);
        if (old != flag) {
            this.modifiedLabel.setText(flag ? "Mod" : "---");
            this.topPanel.validate();
            this.topPanel.repaint();
        }
    }

    void bringModuleToFront(Module module) {
        if (this.patchPanel != null) {
            this.patchPanel.remove(module.getPanel());
            this.patchPanel.add((Component)module.getPanel(), 0);
            this.patchPanel.validate();
            this.patchPanel.repaint();
        }
    }

    void addModule(Module module) {
        module.setLocation(30 + (int)(Math.random() * 20.0), 30 + (int)(Math.random() * 20.0));
        if (this.patchPanel != null) {
            this.patchPanel.addModule(module);
        }
        String name = module.getName();
        this.modules.addElement(module);
        module.setPatch(this);
        this.setModified(true);
        module.start();
    }

    void removeModule(Module module) {
        module.stop();
        this.modules.removeElement(module);
        module.removeFromPatch();
        if (this.patchPanel != null) {
            this.patchPanel.remove(module.getPanel());
            this.patchPanel.validate();
            this.patchPanel.repaint();
        }
        this.setModified(true);
    }

    @Override
    boolean edit() {
        this.show();
        return true;
    }

    void show() {
        if (this.frame != null) {
            this.frame.setVisible(true);
        }
    }

    void hide() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    @Override
    public boolean delete() {
        boolean cancelled = this.saveIfNeeded();
        if (!cancelled) {
            this.frame.hide();
            while (this.modules.size() > 0) {
                Module module = (Module)this.modules.firstElement();
                if (!module.delete()) continue;
                return true;
            }
            cancelled = super.delete();
        }
        return cancelled;
    }

    void setupMenus() {
        this.menuBar = new MenuBar();
        this.fileMenu = new Menu("File", true);
        MenuItem openPatchItem = new MenuItem("Open Patch...");
        openPatchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch pch = Patch.this.addPatchFromFile();
                if (pch != null) {
                    pch.edit();
                }
            }
        });
        this.fileMenu.add(openPatchItem);
        MenuItem saveItem = new MenuItem("Save");
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Patch.this.saveFile == null) {
                    Patch.this.saveAs();
                } else {
                    Patch.this.saveAs(Patch.this.saveFile);
                }
            }
        });
        this.fileMenu.add(saveItem);
        MenuItem saveAsItem = new MenuItem("Save As...");
        saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.saveAs();
            }
        });
        this.fileMenu.add(saveAsItem);
        MenuItem genSourceItem = new MenuItem("Export as Java Source...");
        genSourceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.generateSource();
            }
        });
        this.fileMenu.add(genSourceItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu = new Menu("Edit", true);
        MenuItem tempItem = new MenuItem("Cut", new MenuShortcut(120));
        tempItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.cutSelected();
            }
        });
        this.editMenu.add(tempItem);
        tempItem = new MenuItem("Copy", new MenuShortcut(99));
        tempItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.copySelected();
            }
        });
        this.editMenu.add(tempItem);
        tempItem = new MenuItem("Paste", new MenuShortcut(118));
        tempItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.paste();
            }
        });
        this.editMenu.add(tempItem);
        tempItem = new MenuItem("Delete");
        tempItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.deleteSelected();
            }
        });
        this.editMenu.add(tempItem);
        this.menuBar.add(this.editMenu);
        this.viewMenu = new Menu("View", true);
        MenuItem item = new MenuItem("Main Window");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wire.showMain();
            }
        });
        this.viewMenu.add(item);
        item = new MenuItem("Parent");
        item.addActionListener(this.showParentActionListener);
        this.viewMenu.add(item);
        this.menuBar.add(this.viewMenu);
        this.addMenu = new Menu("Add", true);
        Menu oscMenu = new Menu("Oscillators");
        this.addMenu.add(oscMenu);
        this.addUnitItem(oscMenu, "ImpulseOscillator, impOsc");
        this.addUnitItem(oscMenu, "ImpulseOscillatorBL, impOscBl");
        this.addUnitItem(oscMenu, "PulseOscillator, plsOsc");
        this.addUnitItem(oscMenu, "PulseOscillatorBL, plsOscBl");
        this.addUnitItem(oscMenu, "SawtoothOscillator, sawOsc");
        this.addUnitItem(oscMenu, "SawtoothOscillatorBL,sawOscBl");
        this.addUnitItem(oscMenu, "SawtoothOscillatorDPW,sawOscDPW");
        this.addUnitItem(oscMenu, "SineOscillator, sinOsc");
        this.addUnitItem(oscMenu, "SquareOscillator, sqrOsc");
        this.addUnitItem(oscMenu, "SquareOscillatorBL, sqrOscBl");
        this.addUnitItem(oscMenu, "TriangleOscillator, triOsc");
        Menu samplerMenu = new Menu("Samplers");
        this.addMenu.add(samplerMenu);
        this.addUnitItem(samplerMenu, "SampleReader_16F1, s16f1rd");
        this.addUnitItem(samplerMenu, "SampleReader_16F2, s16f2rd");
        this.addUnitItem(samplerMenu, "SampleReader_16V1, s16v1rd");
        this.addUnitItem(samplerMenu, "SampleReader_16V2, s16v2rd");
        this.addUnitItem(samplerMenu, "SampleWriter_16F1, s16f1wr");
        this.addUnitItem(samplerMenu, "SampleWriter_16F2, s16f2wr");
        Menu filterMenu = new Menu("Filters");
        this.addMenu.add(filterMenu);
        this.addUnitItem(filterMenu, "Filter_LowPass, lowPass");
        this.addUnitItem(filterMenu, "Filter_HighPass, highPass");
        this.addUnitItem(filterMenu, "Filter_BandPass, bandPass");
        this.addUnitItem(filterMenu, "Filter_BandStop, bandStop");
        this.addUnitItem(filterMenu, "Filter_PeakingEQ, peakEQ");
        this.addUnitItem(filterMenu, "Filter_LowShelf, lowShelf");
        this.addUnitItem(filterMenu, "Filter_HighShelf, highShelf");
        this.addUnitItem(filterMenu, "Filter_1o1p, flt1o1p");
        this.addUnitItem(filterMenu, "Filter_1o1p1z, flt1o1p1z");
        this.addUnitItem(filterMenu, "Filter_1o1z, flt1o1z");
        this.addUnitItem(filterMenu, "Filter_2o2p, flt2o2p");
        this.addUnitItem(filterMenu, "Filter_2o2p2z, flt2o2p2z");
        this.addUnitItem(filterMenu, "Filter_StateVariable, fltSVF");
        this.addUnitItem(filterMenu, "DelayUnit, delay");
        this.addUnitItem(filterMenu, "InterpolatingDelayUnit, iDelay");
        Menu mathMenu = new Menu("Arithmetic");
        this.addMenu.add(mathMenu);
        this.addUnitItem(mathMenu, "AddUnit, add");
        this.addUnitItem(mathMenu, "CompareUnit, compare");
        this.addUnitItem(mathMenu, "CrossFade, xfade");
        this.addUnitItem(mathMenu, "DivideUnit, div");
        this.addUnitItem(mathMenu, "LatchUnit, latch");
        this.addUnitItem(mathMenu, "IntegrateUnit, intgrt");
        this.addUnitItem(mathMenu, "MaximumUnit, max");
        this.addUnitItem(mathMenu, "MinimumUnit, min");
        this.addUnitItem(mathMenu, "MultiplyAddUnit, multAdd");
        this.addUnitItem(mathMenu, "MultiplyUnit, mult");
        this.addUnitItem(mathMenu, "PanUnit, pan");
        this.addUnitItem(mathMenu, "SchmidtTrigger, schmidt");
        this.addUnitItem(mathMenu, "SelectUnit, select");
        this.addUnitItem(mathMenu, "SubtractUnit, sub");
        Menu ctrlMenu = new Menu("Control");
        this.addMenu.add(ctrlMenu);
        this.addUnitItem(ctrlMenu, "EnvelopePlayer, envPlay");
        this.addUnitItem(ctrlMenu, "ExponentialLag, expLag");
        this.addUnitItem(ctrlMenu, "LinearLag, linLag");
        this.addUnitItem(ctrlMenu, "ParabolicEnvelope, prblEnv");
        this.addUnitItem(ctrlMenu, "PanControlUnit, panCtrl");
        this.addUnitItem(ctrlMenu, "PeakFollower, peakFlwr");
        this.addUnitItem(ctrlMenu, "PitchDetector, pitchDet");
        Menu ioMenu = new Menu("I/O");
        this.addMenu.add(ioMenu);
        this.addUnitItem(ioMenu, "LineOut, lineOut");
        this.addUnitItem(ioMenu, "LineIn, lineIn");
        Menu noiseMenu = new Menu("Noise");
        this.addMenu.add(noiseMenu);
        this.addUnitItem(noiseMenu, "PinkNoise, pinkNse");
        this.addUnitItem(noiseMenu, "RedNoise, redNse");
        this.addUnitItem(noiseMenu, "WhiteNoise, wtNoise");
        Menu dataMenu = new Menu("Data");
        this.addMenu.add(dataMenu);
        this.addMiscItem(dataMenu, "EnvelopeModule, envelope");
        this.addMiscItem(dataMenu, "SampleModule, sample");
        Menu portsMenu = new Menu("External Ports");
        this.addMenu.add(portsMenu);
        this.addMiscItem(portsMenu, "InputPort, input");
        this.addMiscItem(portsMenu, "VariablePort, varPort");
        this.addMiscItem(portsMenu, "EnvelopeQueuePort, envelopePort");
        this.addMiscItem(portsMenu, "SampleQueuePort, samplePort");
        this.addMiscItem(portsMenu, "OutputPort, output");
        Menu miscMenu = new Menu("Miscellaneous");
        this.addMenu.add(miscMenu);
        this.addUnitItem(miscMenu, "TwoInDualOutUnit, 2toDual");
        this.addUnitItem(miscMenu, "DualInTwoOutUnit, dualTo2");
        this.addMiscItem(miscMenu, "NumericTextModule");
        this.addMiscItem(miscMenu, "NumericFaderModule");
        this.addMiscItem(miscMenu, "NumericKnobModule");
        this.addMiscItem(miscMenu, "VuDisplayModule");
        this.addMiscItem(miscMenu, "Comment");
        this.addMiscItem(miscMenu, "WAVRecorder");
        item = new MenuItem("Empty Patch");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.addEmptyPatch();
            }
        });
        this.addMenu.add(item);
        item = new MenuItem("SynthNote Patch");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.addSynthNotePatch();
            }
        });
        this.addMenu.add(item);
        item = new MenuItem("Patch from File...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.addPatchFromFile();
            }
        });
        this.addMenu.add(item);
        item = new MenuItem("Circuit by Name...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.addCircuitByName();
            }
        });
        this.addMenu.add(item);
        this.menuBar.add(this.addMenu);
    }

    @Override
    public void noteOn(int time, double frequency, double amplitude) {
        int i = 0;
        while (i < this.modules.size()) {
            Module module = (Module)this.modules.elementAt(i);
            module.noteOn(time, frequency, amplitude);
            ++i;
        }
    }

    @Override
    public void noteOff(int time) {
        int i = 0;
        while (i < this.modules.size()) {
            Module module = (Module)this.modules.elementAt(i);
            module.noteOff(time);
            ++i;
        }
    }

    double convertIndexToFreq(int index) {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        int[] scale = nArray;
        int octave = index / scale.length;
        int idx = index % scale.length;
        int pitch = octave * 12 + scale[idx];
        return EqualTemperedTuning.getMIDIFrequency(pitch + 48);
    }

    boolean startNoteByKey(int key) throws SynthException {
        int index = keyboard.indexOf(key);
        if (index < 0) {
            return false;
        }
        double freq = this.convertIndexToFreq(index);
        this.noteOn(Synth.getTickCount(), freq, 0.5);
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key != this.lastKeyDown) {
            this.lastKeyDown = key;
            this.startNoteByKey(key);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == this.lastKeyDown) {
            this.lastKeyDown = -1;
            this.noteOff(Synth.getTickCount());
        }
    }

    void setupTopPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        JPanel topLeftPanel = new JPanel();
        this.topPanel.add("West", topLeftPanel);
        this.keyButton = new JButton("Play Keys");
        this.keyButton.addKeyListener(this);
        this.keyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patch.this.keyButton.requestFocus();
            }
        });
        topLeftPanel.add(this.keyButton);
        if (this.patch != null) {
            this.upButton = new JButton("Up");
            topLeftPanel.add(this.upButton);
            this.upButton.addActionListener(this.showParentActionListener);
        }
        this.modifiedLabel = new JLabel("----", 0);
        topLeftPanel.add(this.modifiedLabel);
        this.faderLabel = new JLabel("0.0", 0);
        this.topPanel.add("Center", this.faderLabel);
        this.topPanel.setBackground(Color.gray.brighter());
        this.frame.getContentPane().add((Component)this.topPanel, "North");
    }

    void showFaderValue(String text, double value) {
        if (this.faderLabel != null) {
            this.faderLabel.setText(String.valueOf(text) + " = " + NumericOutput.doubleToString(value, 8, 5));
        }
    }

    String buildHierarchyName() {
        String hierName = this.patch == null ? "" : String.valueOf(this.patch.buildHierarchyName()) + ".";
        hierName = String.valueOf(hierName) + this.getName();
        return hierName;
    }

    String buildWindowName() {
        String windowName = this.buildHierarchyName();
        if (this.saveFile != null) {
            windowName = String.valueOf(windowName) + " - " + Wire.makePathRelative(this.saveFile.getPath());
        }
        return windowName;
    }

    void setupPatchWindow() {
        this.frame = new JFrame(this.buildWindowName());
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        GlassPatchOverlay patchOverlay = new GlassPatchOverlay();
        this.frame.setGlassPane(patchOverlay);
        patchOverlay.setPreferredSize(new Dimension(200, 300));
        patchOverlay.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
            }
        });
        this.showParentActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Patch.this.patch != null) {
                    Patch.this.patch.show();
                }
            }
        };
        this.setupTopPanel();
        this.patchPanel = new PatchPanel(this);
        JScrollPane scrollPane = new JScrollPane(this.patchPanel, 20, 30);
        contentPane.add((Component)scrollPane, "Center");
        this.frame.setBounds(200 + (int)(Math.random() * 50.0), 100 + (int)(Math.random() * 50.0), 500, 500);
        this.frame.validate();
        this.setupMenus();
        this.frame.setMenuBar(this.menuBar);
        String message = "This patch has been modified. Save changes to disk?";
        this.saveIfNeededDialog = new MessageDialog(this.frame, 1, message.length() + 4, "Yes", "No", "Cancel");
        this.saveIfNeededDialog.setText(message);
        this.saveIfNeededDialog.setSize(420, 120);
    }

    String stripTrailingDigits(String text) {
        int lastDigit = -1;
        int len = text.length();
        int i = 0;
        while (i < len - 1) {
            int pos = len - 1 - i;
            char c = text.charAt(pos);
            if (c < '0' || c > '9') break;
            lastDigit = pos;
            ++i;
        }
        if (lastDigit > 0) {
            text = text.substring(0, lastDigit);
        }
        return text;
    }

    synchronized String makeNameUnique(String name) {
        if (this.findModule(name) != null) {
            name = this.stripTrailingDigits(name);
        }
        int i = 2;
        String newName = name;
        while (this.findModule(newName) != null) {
            newName = String.valueOf(name) + i++;
            if (i <= 5000) continue;
            newName = String.valueOf(name) + "_BAD";
            break;
        }
        return newName;
    }

    String extractNameType(String commaName, String defaultNameprefix) {
        String tempName;
        int commaIndex = commaName.indexOf(44);
        if (commaIndex > 0) {
            this.tempType = commaName.substring(0, commaIndex);
            int ic = commaIndex + 1;
            while (commaName.charAt(ic) == ' ') {
                ++ic;
            }
            tempName = commaName.substring(ic, commaName.length());
        } else {
            this.tempType = commaName;
            tempName = defaultNameprefix;
        }
        return this.makeNameUnique(tempName);
    }

    void addUnitItem(Menu menu, String name) {
        MenuItem item = new MenuItem(name);
        menu.add(item);
        item.setActionCommand(name);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = e.getActionCommand();
                String nickName = Patch.this.extractNameType(text, "unit");
                Patch.this.addUnit(nickName, Patch.this.tempType, 0.0, true);
            }
        });
    }

    void addMiscItem(Menu menu, String name) {
        MenuItem item = new MenuItem(name);
        menu.add(item);
        item.setActionCommand(name);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = e.getActionCommand();
                String nickName = Patch.this.extractNameType(text, "misc");
                Patch.this.addMisc(nickName, Patch.this.tempType, true);
            }
        });
    }

    void test1() throws SynthException {
        this.addMisc("misc1", "NumericTextModule").setLocation(50, 100);
        this.addUnit("sine1", "SineOscillator", 0.0, false).setLocation(200, 200);
        this.addUnit("out", "LineOut", 0.0, false).setLocation(400, 100);
    }

    @Override
    String getTagName() {
        return "patch";
    }

    @Override
    void setPatch(Patch patch) {
        super.setPatch(patch);
        this.refreshWindowName();
    }

    public void setFile(File file) {
        this.className = this.extractClassName(file);
        this.saveFile = file;
        this.refreshWindowName();
    }

    void refreshWindowName() {
        if (this.frame != null) {
            this.frame.setTitle(this.buildWindowName());
        }
    }

    public File getFile() {
        return this.saveFile;
    }

    void warnInputNeeded(String type) {
        if (!Wire.wireApp.isInputEnabled() && Wire.wireApp.isOutputEnabled()) {
            MessageDialog dlg = new MessageDialog("Audio Input must be enabled for " + type + " to work.", "Enable Input Only", "Enable Both Input and Output", "No Change");
            int result = dlg.ask();
            switch (result) {
                case 0: {
                    Wire.wireApp.engineInputOnly();
                    break;
                }
                case 1: {
                    Wire.wireApp.engineInputOutput();
                }
            }
        }
    }

    public UnitModule addUnit(String name, String type, double parameter, boolean isInteractive) {
        UnitModule unit = null;
        try {
            String remapType = (String)paramUnitRemaps.get(type);
            if (remapType == null) {
                SynthSound sound = (SynthSound)this.makeObject("com.softsynth.jsyn." + type);
                if (sound != null) {
                    unit = new UnitModule(sound);
                    if (type.equals("LineIn")) {
                        this.warnInputNeeded(type);
                    }
                } else {
                    TextOutput.println("Could not create " + type);
                }
            } else {
                ParameterizedUnitModule paramModule = (ParameterizedUnitModule)this.makeObject("com.softsynth.wire." + remapType);
                if (isInteractive) {
                    paramModule.setPatch(this);
                    paramModule.editBeforeMake();
                } else {
                    paramModule.setParameter(parameter);
                }
                paramModule.remakeUnit();
                unit = paramModule;
            }
            unit.setup(this, name, type);
            if (isInteractive) {
                unit.editAfterMake();
            }
            this.addModule(unit);
        }
        catch (SynthException e) {
            TextOutput.println("Error adding " + type + e);
            e.printStackTrace();
        }
        return unit;
    }

    public Module addMisc(String name, String type) {
        return this.addMisc(name, type, false);
    }

    public Module addMisc(String name, String type, boolean isInteractive) {
        Module module = (Module)this.makeObject("com.softsynth.wire." + type);
        if (module != null) {
            module.setup(this, name, type);
            if (isInteractive) {
                if (module.edit()) {
                    this.addModule(module);
                }
            } else {
                this.addModule(module);
            }
        } else {
            TextOutput.println("Could not make module " + type);
        }
        return module;
    }

    Object makeObject(String className) {
        Object obj = null;
        Class<?> c = null;
        try {
            c = Class.forName(className);
            try {
                obj = c.newInstance();
            }
            catch (InstantiationException e) {
                TextOutput.println("Could not instantiate " + className + e);
            }
            catch (IllegalAccessException e) {
                TextOutput.println("Illegal access to " + className + e);
            }
        }
        catch (ClassNotFoundException e) {
            TextOutput.println("Could not find " + className);
        }
        return obj;
    }

    String extractRootName(File file) {
        String result = file.getName();
        int iDot = result.indexOf(46);
        if (iDot > 0) {
            result = result.substring(0, iDot);
        }
        return result;
    }

    String extractClassName(File file) {
        String cName = this.extractRootName(file);
        if (Character.isLowerCase(cName.charAt(0))) {
            StringBuffer sbuf = new StringBuffer(cName);
            sbuf.setCharAt(0, (char)(sbuf.charAt(0) - 97 + 65));
            cName = sbuf.toString();
        }
        return cName;
    }

    String extractPackageName(File file) {
        String packageName = "patches";
        String pathName = file.getParent().toLowerCase();
        if (pathName != null) {
            int index = (pathName = pathName.replace(File.separatorChar, '.')).indexOf(".com.");
            if (index >= 0) {
                packageName = pathName.substring(index + 1);
            } else {
                index = pathName.indexOf(".org.");
                if (index >= 0) {
                    packageName = pathName.substring(index + 5);
                } else {
                    index = pathName.indexOf(".jsrc.");
                    if (index >= 0) {
                        packageName = pathName.substring(index + 6);
                    } else {
                        index = pathName.indexOf(".source.");
                        if (index >= 0) {
                            packageName = pathName.substring(index + 8);
                        }
                    }
                }
            }
        }
        return packageName;
    }

    void generateSource() {
        File sourceFile = Wire.browseSave(new File(this.sourceDir, String.valueOf(this.className) + ".java"));
        if (sourceFile == null) {
            return;
        }
        String sourcePath = sourceFile.getPath();
        try {
            if (!sourcePath.endsWith(".java")) {
                sourcePath = String.valueOf(sourcePath) + ".java";
                sourceFile = new File(sourcePath);
            }
            FileOutputStream fileStream = new FileOutputStream(sourceFile);
            IndentingWriter saveStream = new IndentingWriter(fileStream);
            this.className = this.extractClassName(sourceFile);
            String packageName = this.extractPackageName(sourceFile);
            this.generateTopSource(saveStream, this.className, packageName);
            saveStream.close();
            fileStream.close();
            this.sourceDir = sourceFile.getParent();
        }
        catch (IOException e) {
            TextOutput.println("Could not write source code file = " + sourceFile);
        }
        catch (SecurityException e) {
            TextOutput.println("Caught " + e);
            System.exit(1);
        }
    }

    @Override
    public void generateSource(IndentingWriter writer, int phase) throws IOException {
        super.generateSource(writer, phase);
        switch (phase) {
            case 0: {
                writer.println(String.valueOf(this.className) + " " + this.getName() + ";");
                break;
            }
            case 1: {
                writer.println("add( " + this.getName() + " = new " + this.className + "(synthContext) );");
                break;
            }
            case 4: {
                writer.println(String.valueOf(this.getName()) + ".setStage( time, stage);");
            }
        }
    }

    void generateTopSource(IndentingWriter writer, String circuitName, String packageName) throws IOException {
        Module module;
        writer.setIndentation(0);
        writer.println("package " + packageName + ";");
        writer.println("import java.io.*;");
        writer.println("import com.softsynth.jsyn.*;");
        writer.println("/**************");
        writer.println("** WARNING - this code automatically generated by Wire.");
        writer.println("** The real source is probably a Wire patch.");
        writer.println("** Do NOT edit this file unless you copy it to another directory and change the name.");
        writer.println("** Otherwise it is likely to get clobbered the next time you");
        writer.println("** export Java source code from Wire.");
        writer.println("**");
        writer.println("** Wire is available from: http://www.softsynth.com/wire/");
        writer.println("*/");
        writer.println("public class " + circuitName + " extends SynthNote");
        writer.println("{");
        writer.indent();
        writer.println("// Declare units and ports.");
        int i = 0;
        while (i < this.modules.size()) {
            module = (Module)this.modules.elementAt(i);
            module.generateSource(writer, 0);
            ++i;
        }
        writer.println();
        writer.println("public " + circuitName + "()");
        writer.println("{");
        writer.indent();
        writer.println("this( Synth.getSharedContext() );");
        writer.undent();
        writer.println("}");
        writer.println("public " + circuitName + "( SynthContext synthContext )");
        writer.println("{");
        writer.indent();
        writer.println("super( synthContext );");
        writer.println("// Create unit generators.");
        i = 0;
        while (i < this.modules.size()) {
            module = (Module)this.modules.elementAt(i);
            module.generateSource(writer, 1);
            ++i;
        }
        writer.println("// Connect units and ports.");
        i = 0;
        while (i < this.modules.size()) {
            module = (Module)this.modules.elementAt(i);
            module.generateSource(writer, 2);
            ++i;
        }
        writer.undent();
        writer.println("}");
        i = 0;
        while (i < this.modules.size()) {
            module = (Module)this.modules.elementAt(i);
            module.generateSource(writer, 3);
            ++i;
        }
        writer.println("");
        writer.println("public void setStage( int time, int stage )");
        writer.println("{");
        writer.indent();
        i = 0;
        while (i < this.modules.size()) {
            module = (Module)this.modules.elementAt(i);
            module.generateSource(writer, 4);
            ++i;
        }
        writer.println("switch( stage )");
        writer.println("{");
        writer.println("case 0:");
        writer.indent();
        i = 0;
        while (i < this.modules.size()) {
            module = (Module)this.modules.elementAt(i);
            module.generateSource(writer, 5);
            ++i;
        }
        writer.println("start( time );");
        writer.println("break;");
        writer.undent();
        writer.println("case 1:");
        writer.indent();
        i = 0;
        while (i < this.modules.size()) {
            module = (Module)this.modules.elementAt(i);
            module.generateSource(writer, 6);
            ++i;
        }
        writer.println("break;");
        writer.undent();
        writer.println("default:");
        writer.indent();
        writer.println("break;");
        writer.undent();
        writer.println("}");
        writer.undent();
        writer.println("}");
        writer.undent();
        writer.println("}");
    }

    void saveGroupToStream(Vector units, Rectangle rect, SaveAsStream stream) throws IOException {
        Module module;
        stream.startGroup(rect);
        int i = 0;
        while (i < units.size()) {
            module = (Module)units.elementAt(i);
            module.saveCreationToStream(stream);
            ++i;
        }
        i = 0;
        while (i < units.size()) {
            module = (Module)units.elementAt(i);
            module.saveConnectionsToStream(units, stream);
            ++i;
        }
        stream.endGroup();
    }

    void saveTopToStream(Vector units, Rectangle rect, SaveAsStream stream) throws IOException {
        stream.begin();
        this.saveGroupToStream(units, rect, stream);
        stream.end();
    }

    @Override
    public boolean saveTreeIfNeeded() {
        int i = 0;
        while (i < this.modules.size()) {
            Module module = (Module)this.modules.elementAt(i);
            boolean cancel = module.saveTreeIfNeeded();
            if (cancel) {
                return cancel;
            }
            ++i;
        }
        return this.saveIfNeeded();
    }

    boolean saveIfNeeded() {
        boolean cancelled = false;
        if (this.getModified() && this.modules.size() > 1) {
            this.show();
            Point framePoint = this.frame.getLocation();
            framePoint.x += 20;
            framePoint.y += 50;
            this.saveIfNeededDialog.setLocation(framePoint);
            int result = this.saveIfNeededDialog.ask();
            if (result == 0) {
                return this.saveAs();
            }
            if (result == 2) {
                cancelled = true;
            }
        }
        return cancelled;
    }

    boolean saveAs() {
        File file = Wire.browseSave(this.getRecommendedSaveFile());
        if (file == null) {
            return true;
        }
        String tempPath = file.getPath();
        if (!tempPath.endsWith(".xml")) {
            tempPath = String.valueOf(tempPath) + ".xml";
            file = new File(tempPath);
        }
        this.saveAs(file);
        return false;
    }

    void saveAs(File file) {
        try {
            FileOutputStream fileStream = new FileOutputStream(file);
            this.setFile(file);
            SaveAsStream saveStream = new SaveAsStream(fileStream);
            Rectangle rect = null;
            if (this.patchPanel != null) {
                rect = this.patchPanel.getFrame().bounds();
            }
            saveStream.setTargetFile(file);
            this.saveTopToStream(this.modules, rect, saveStream);
            saveStream.close();
            fileStream.close();
        }
        catch (IOException e) {
            TextOutput.println("Could not save to file = " + this.saveFile);
        }
        catch (SecurityException e) {
            TextOutput.println("Caught " + e);
            System.exit(1);
        }
        this.setModified(false);
    }

    @Override
    void saveContentToStream(SaveAsStream stream) throws IOException {
        super.saveContentToStream(stream);
        if (this.saveFile != null && this.getModified()) {
            this.saveIfNeeded();
        }
        if (this.saveFile == null || this.getModified()) {
            this.saveGroupToStream(this.modules, this.getEditorBounds(), stream);
        } else {
            stream.writeFileLink(this.saveFile.getPath());
            stream.writeEditor(this.getEditorBounds());
        }
    }

    void deselectAll() {
        while (this.selected.size() > 0) {
            Module module = (Module)this.selected.firstElement();
            this.deselectModule(module);
        }
    }

    void selectModule(Module module) {
        this.selected.addElement(module);
        module.setSelected(true);
    }

    void deselectModule(Module module) {
        this.selected.removeElement(module);
        module.setSelected(false);
    }

    void copySelected() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        SaveAsStream stream = new SaveAsStream(byteStream);
        try {
            this.saveTopToStream(this.selected, null, stream);
            stream.flush();
            pasteBuffer = byteStream.toByteArray();
            this.pasteOffset = 0;
        }
        catch (IOException e) {
            TextOutput.println("Caught " + e);
        }
    }

    void paste() {
        if (pasteBuffer != null) {
            this.deselectAll();
            ByteArrayInputStream stream = new ByteArrayInputStream(pasteBuffer);
            new TopLoader(this, true).load(stream);
            this.pasteOffset += 10;
            this.getPatchPanel().shiftSelectedModules(this.pasteOffset, this.pasteOffset);
        }
    }

    void cutSelected() {
        this.copySelected();
        this.deleteSelected();
    }

    void deleteSelected() {
        boolean cancelled = false;
        while (this.selected.size() > 0) {
            Module module = (Module)this.selected.firstElement();
            cancelled = module.delete();
            if (cancelled) {
                return;
            }
            this.selected.removeElement(module);
        }
    }

    int selectBoundedModules(Rectangle rect) {
        int num = 0;
        int i = 0;
        while (i < this.modules.size()) {
            Module module = (Module)this.modules.elementAt(i);
            Rectangle modRect = module.getPanel().getBounds();
            if (rect.contains(modRect.x, modRect.y) && rect.contains(modRect.x + modRect.width, modRect.y + modRect.height)) {
                this.selectModule(module);
                ++num;
            }
            ++i;
        }
        return num;
    }

    public void drawPatchConnections(Graphics g, Point refLoc) {
        Module module;
        int i = 0;
        while (i < this.modules.size()) {
            module = (Module)this.modules.elementAt(i);
            if (!module.getSelected()) {
                module.drawConnections(g, refLoc);
            }
            ++i;
        }
        i = 0;
        while (i < this.modules.size()) {
            module = (Module)this.modules.elementAt(i);
            if (module.getSelected()) {
                module.drawConnections(g, refLoc);
            }
            ++i;
        }
    }

    Patch addSynthNotePatch() {
        Patch subPatch = this.addEmptyPatch();
        InputPort inPort = (InputPort)subPatch.addMisc("frequency", "InputPort");
        inPort.setLocation(50, 100);
        inPort.portJack.setMax(3000.0);
        inPort.portJack.set(440.0);
        subPatch.addMisc("amplitude", "InputPort").setLocation(50, 150);
        subPatch.addMisc("output", "OutputPort").setLocation(350, 100);
        return subPatch;
    }

    public CircuitModule addCircuit(String name, String fullClassName) {
        CircuitModule circ = null;
        Object obj = this.makeObject(fullClassName);
        if (obj instanceof SynthCircuit) {
            SynthCircuit sound = (SynthCircuit)obj;
            try {
                if (sound != null) {
                    circ = new CircuitModule(sound);
                    circ.setup(this, name, fullClassName);
                    this.addModule(circ);
                } else {
                    TextOutput.println("Could not create " + fullClassName);
                }
            }
            catch (SynthException e) {
                TextOutput.println("Error adding " + fullClassName + " " + e);
                e.printStackTrace();
            }
            return circ;
        }
        MessageDialog dlg = new MessageDialog("Chosen class is not a subclass of SynthCircuit!", "OK");
        dlg.ask();
        return null;
    }

    SampleModule addSampleFromFile(String name, File file) {
        SampleModule sampleModule = new SampleModule();
        sampleModule.setup(this, name, "Sample");
        sampleModule.loadFromFile(file);
        this.addModule(sampleModule);
        return sampleModule;
    }

    SampleModule addSample(String name, int numFrames, int numChannels) {
        SampleModule sampleModule = new SampleModule();
        sampleModule.setup(this, name, "Sample");
        sampleModule.remakeSample(numFrames, numChannels);
        this.addModule(sampleModule);
        return sampleModule;
    }

    Patch addPatchFromFile() {
        File file = this.getRecommendedLoadFile();
        if ((file = Wire.browseLoad(file)) == null) {
            return null;
        }
        this.setRecommendedLoadFile(file);
        return this.addPatchFromFile(this.makeNameUnique("patch"), file);
    }

    CircuitModule addCircuitByName() {
        GetTextDialog dlg = new GetTextDialog((Frame)this.frame, "Enter class name:", defaultCircuitName);
        String name = dlg.ask();
        if (name == null) {
            return null;
        }
        defaultCircuitName = name;
        return this.addCircuit(this.makeNameUnique("circuit"), name);
    }

    Patch addEmptyPatch() {
        return this.addEmptyPatch(this.makeNameUnique("patch"));
    }

    Patch addEmptyPatch(String name) {
        Patch subPatch = new Patch();
        subPatch.setup(this, name, "Patch");
        subPatch.setupPatchWindow();
        this.addModule(subPatch);
        return subPatch;
    }

    Patch addPatchFromFile(String name, File file) {
        Patch subPatch = this.addEmptyPatch(name);
        subPatch.loadFromFile(file);
        return subPatch;
    }

    @Override
    boolean loadFromFile(File file) {
        boolean result = true;
        try {
            FileInputStream fileStream = new FileInputStream(file);
            BufferedInputStream bufInputStream = new BufferedInputStream(fileStream);
            this.setFile(file);
            new TopLoader(this).load(bufInputStream);
            this.setModified(false);
            bufInputStream.close();
            result = false;
        }
        catch (IOException e) {
            TextOutput.println("Could not open file = " + file);
        }
        catch (SecurityException e) {
            TextOutput.println("Caught " + e);
            System.exit(1);
        }
        return result;
    }

    class GlassPatchOverlay
    extends JComponent {
        GlassPatchOverlay() {
        }

        @Override
        public void paint(Graphics g) {
            if (this.isShowing()) {
                Patch.this.drawPatchConnections(g, this.getLocationOnScreen());
            }
        }
    }
}

