/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import java.awt.Color;
import java.awt.Graphics;

class RubberBand {
    int lastX;
    int lastY;
    int lastWidth;
    int lastHeight;
    int startX;
    int startY;
    Color bandColor = Color.white;

    RubberBand() {
    }

    public void startLine(int x, int y) {
        this.lastX = this.startX = x;
        this.lastY = this.startY = y;
    }

    public void drawLine(Graphics g, int x, int y) {
        g.setXORMode(this.bandColor);
        g.drawLine(this.startX, this.startY, this.lastX, this.lastY);
        g.drawLine(this.startX, this.startY, x, y);
        g.setPaintMode();
        this.lastX = x;
        this.lastY = y;
    }

    public void endLine(Graphics g) {
        g.setXORMode(this.bandColor);
        g.drawLine(this.startX, this.startY, this.lastX, this.lastY);
        g.setPaintMode();
    }

    public void startRectangle(int x, int y, int width, int height) {
        this.lastX = this.startX = x;
        this.lastY = this.startY = y;
        this.lastWidth = width;
        this.lastHeight = height;
    }

    void drawRectangle(Graphics g, int x, int y, int width, int height) {
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        g.drawRect(x, y, width, height);
    }

    public void dragRectangle(Graphics g, int x, int y) {
        g.setXORMode(this.bandColor);
        this.drawRectangle(g, this.startX, this.startY, this.lastWidth, this.lastHeight);
        this.lastWidth = x - this.startX;
        this.lastHeight = y - this.startY;
        this.drawRectangle(g, this.startX, this.startY, this.lastWidth, this.lastHeight);
        g.setPaintMode();
    }

    public void startMovingRectangle(Graphics g, int x, int y, int width, int height) {
        this.lastX = x;
        this.lastY = y;
        this.lastWidth = width;
        this.lastHeight = height;
        g.drawRect(x, y, width, height);
    }

    public void moveRectangle(Graphics g, int x, int y) {
        g.setXORMode(this.bandColor);
        g.drawRect(this.lastX, this.lastY, this.lastWidth, this.lastHeight);
        g.drawRect(x, y, this.lastWidth, this.lastHeight);
        g.setPaintMode();
        this.lastX = x;
        this.lastY = y;
    }

    public void endRectangle(Graphics g) {
        g.setXORMode(this.bandColor);
        g.drawRect(this.lastX, this.lastY, this.lastWidth, this.lastHeight);
        g.setPaintMode();
    }
}

