/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class TestMouseEntered
extends Applet
implements MouseListener {
    private static final long serialVersionUID = 1L;
    final Applet applet = this;
    TextArea textArea;

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        Panel topPanel = new Panel();
        topPanel.setLayout(new GridLayout(1, 2));
        topPanel.add(new ColoredCanvas(Color.blue));
        topPanel.add(new ColoredCanvas(Color.green));
        this.add("North", topPanel);
        this.textArea = new TextArea();
        this.add("Center", this.textArea);
        this.println("java.version = " + System.getProperty("java.version"));
        this.validate();
        this.repaint();
    }

    @Override
    public void stop() {
        this.removeAll();
    }

    private void println(String text) {
        this.textArea.append(String.valueOf(text) + "\n");
    }

    private void logMouseEvent(MouseEvent evt) {
        this.println("Got: " + evt);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.logMouseEvent(evt);
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.logMouseEvent(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.logMouseEvent(evt);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.logMouseEvent(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.logMouseEvent(evt);
    }

    public static void main(String[] args) {
        TestMouseEntered test = new TestMouseEntered();
        Frame frame = new Frame("Test Mouse Entered Bug");
        frame.setSize(600, 400);
        frame.setLayout(new BorderLayout());
        frame.add("Center", test);
        frame.setVisible(true);
        test.start();
    }

    class ColoredCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;

        ColoredCanvas(Color color) {
            this.setBackground(color);
            this.setSize(100, 100);
            this.addMouseListener((MouseListener)((Object)TestMouseEntered.this.applet));
        }

        @Override
        public void paint(Graphics g) {
            int width = this.getBounds().width;
            int height = this.getBounds().height;
            g.setColor(this.getBackground());
            g.fillRect(1, 1, width - 2, height - 2);
        }
    }
}

