/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.apple.OSXAdapter;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view11x.UsageDisplay;
import com.softsynth.util.TextOutput;
import com.softsynth.wire.AlertUser;
import com.softsynth.wire.Patch;
import com.softsynth.wire.SynthClock;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

public class Wire
extends Applet {
    static final boolean demoVersion = false;
    static final double VERSION = 1.3;
    static final int BUILD_INDEX = 21;
    public static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    public static boolean drawStraightLines = false;
    public static Wire wireApp;
    public static SynthClock clock;
    private static final int XPOS_MAIN_FRAME = 10;
    private static final int YPOS_MAIN_FRAME = 10;
    private static final int WIDTH_MAIN_FRAME = 400;
    private static final int HEIGHT_MAIN_FRAME = 250;
    private static final int XPOS_TEXT_OUTPUT = 10;
    private static final int YPOS_TEXT_OUTPUT = 260;
    Patch topPatch;
    static Frame frame;
    Panel panel;
    MenuBar menuBar;
    Menu fileMenu;
    Menu viewMenu;
    Menu engineMenu;
    MenuItem menuItem;
    String initialPatchName = null;
    CheckboxMenuItem drawStraightItem;
    CheckboxMenuItem checkItemOff;
    CheckboxMenuItem checkItemOutputOnly;
    CheckboxMenuItem checkItemInputOnly;
    CheckboxMenuItem checkItemInputOutput;
    CheckboxMenuItem checkItem22050;
    CheckboxMenuItem checkItem44100;
    boolean running = false;
    double sampleRate;
    private Thread shutdownThread;
    static int index;
    static final Color EXT_PORT_COLOR;
    static final Color SET_PORT_COLOR;
    static final Color CONNECT_PORT_COLOR;
    static final Color ENVQUEUE_PORT_COLOR;
    static final Color SAMPQUEUE_PORT_COLOR;
    static final Color HIGHLIGHT_COLOR;
    static final Color CONNECTOR_COLOR;
    static final Color KNOB_BACKGROUND_COLOR;
    static final int DOES_SET = 1;
    static final int DOES_CONNECT = 2;
    static final int DOES_ENVQUEUE = 4;
    static final int DOES_SAMPQUEUE = 8;
    static final int PORT_HEIGHT = 18;
    static final int PORT_WIDTH = 70;
    static final int PHASE_DECLARE = 0;
    static final int PHASE_CREATE = 1;
    static final int PHASE_CONNECT = 2;
    static final int PHASE_METHODS = 3;
    static final int PHASE_STAGE = 4;
    static final int PHASE_STAGE0 = 5;
    static final int PHASE_STAGE1 = 6;
    static String basePath;

    static {
        clock = null;
        index = 0;
        EXT_PORT_COLOR = Color.green.brighter();
        SET_PORT_COLOR = Color.cyan;
        CONNECT_PORT_COLOR = Color.yellow;
        ENVQUEUE_PORT_COLOR = Color.magenta;
        SAMPQUEUE_PORT_COLOR = Color.lightGray;
        HIGHLIGHT_COLOR = Color.orange;
        CONNECTOR_COLOR = Color.red;
        KNOB_BACKGROUND_COLOR = new Color(230, 240, 255);
    }

    public static void main(String[] args) {
        wireApp = new Wire();
        AppletFrame aframe = new AppletFrame("Wire", wireApp);
        aframe.setSize(400, 250);
        aframe.setLocation(10, 10);
        frame = aframe;
        TextOutput.open();
        if (args.length > 0) {
            Wire.wireApp.initialPatchName = args[0];
        }
        Wire.showMain();
        try {
            aframe.test();
        }
        catch (Error err) {
            TextOutput.println("Caught " + err);
        }
        catch (Exception e) {
            TextOutput.println("Caught " + e);
        }
    }

    public void registerForMacOSXEvents() {
        if (MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quit", null));
            }
            catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public boolean quit() {
        System.out.println("quit() called from Apple menu");
        this.exit();
        return true;
    }

    public static void showMain() {
        if (frame != null) {
            frame.show();
        }
    }

    void reportJavaInfo() {
        TextOutput.println("Java version: " + System.getProperty("java.version"));
        TextOutput.println("Java vendor : " + System.getProperty("java.vendor"));
        TextOutput.println("CPU, System : " + System.getProperty("os.arch") + ", " + System.getProperty("os.version"));
    }

    @Override
    public void start() {
        this.registerForMacOSXEvents();
        basePath = String.valueOf(new File("").getAbsolutePath()) + File.separator;
        this.setLayout(new BorderLayout());
        this.setupGUI();
        this.reportJavaInfo();
        try {
            Synth.setTrace(0);
            Synth.initialize();
            this.engineSetRate(44100.0);
            this.engineOutputOnly();
            this.makeTopPatch();
            this.panel.add(new UsageDisplay());
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            AlertUser.showError((Component)this, e);
        }
        this.shutdownThread = new Thread(){

            @Override
            public void run() {
                Wire.this.onShutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println("Closing main Wire window.");
                Wire.this.exit();
            }
        });
    }

    private void onShutdown() {
        System.out.println("onShutdown(): running ShutdownHookThread.");
        this.stop();
    }

    @Override
    public void stop() {
        System.out.println("Calling Wire.stop()");
        this.removeAll();
        try {
            Synth.verbosity = 0;
            Synth.stop();
            Synth.terminate();
        }
        catch (Error err) {
            System.err.println("Caught " + err);
        }
        catch (Exception e) {
            System.err.println("Caught " + e);
        }
        TextOutput.close();
    }

    void exit() {
        System.out.println("exit() called.");
        boolean cancelled = false;
        if (this.topPatch != null) {
            cancelled = this.topPatch.saveTreeIfNeeded();
        }
        if (!cancelled) {
            this.stop();
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
                this.shutdownThread = null;
            }
            System.exit(0);
        }
    }

    static String stripJSynPackage(String className) {
        String strippedName = Wire.stripPrefix(className, "com.softsynth.jsyn.");
        boolean inSubPackage = strippedName.indexOf(46) >= 0;
        return inSubPackage ? className : strippedName;
    }

    static String makePathRelative(String path) {
        return Wire.stripPrefix(path, basePath);
    }

    static String makePathPortable(String path) {
        String result = Wire.stripPrefix(path, basePath);
        return Wire.convertFileSeparatorsToJava(result);
    }

    static String makePathRelative(String path, File targetFile) {
        String targetPath;
        if (targetFile != null && path.startsWith(targetPath = String.valueOf(targetFile.getParent()) + File.separator)) {
            path = path.substring(targetPath.length(), path.length());
            return Wire.convertFileSeparatorsToJava(path);
        }
        return Wire.makePathPortable(path);
    }

    static String stripPrefix(String text, String prefix) {
        if (prefix != null && text.startsWith(prefix)) {
            text = text.substring(prefix.length(), text.length());
        }
        return text;
    }

    static String convertChars(String path, char fromChar, char toChar) {
        if (path == null) {
            return path;
        }
        StringBuffer sbuf = new StringBuffer(path);
        int i = 0;
        while (i < sbuf.length()) {
            if (sbuf.charAt(i) == fromChar) {
                sbuf.setCharAt(i, toChar);
            }
            ++i;
        }
        return sbuf.toString();
    }

    static String convertFileSeparatorsToJava(String path) {
        return Wire.convertChars(path, File.separatorChar, '/');
    }

    static String convertFileSeparatorsToHost(String path) {
        return Wire.convertChars(path, '/', File.separatorChar);
    }

    public static File browseSave(File defaultFile) {
        return Wire.browseForFile(defaultFile, "Save As...", 1);
    }

    public static File browseLoad(File defaultFile) {
        return Wire.browseForFile(defaultFile, "Select Wire XML File", 0);
    }

    public static File browseForFile(File defaultFile, String message, int mode) {
        FileDialog fileDlg = new FileDialog(frame, message, mode);
        if (defaultFile != null) {
            fileDlg.setDirectory(defaultFile.getParent());
            fileDlg.setFile(defaultFile.getName());
        }
        fileDlg.show();
        File file = null;
        String dirName = fileDlg.getDirectory();
        String fileName = fileDlg.getFile();
        if (fileName != null) {
            file = dirName != null ? new File(dirName, fileName) : new File(fileName);
        }
        return file;
    }

    void makeTopPatch() {
        this.topPatch = new Patch();
        this.topPatch.setName("top");
        this.topPatch.setupPatchWindow();
        if (this.initialPatchName != null) {
            this.topPatch.loadFromFile(new File(this.initialPatchName));
        }
        this.topPatch.edit();
    }

    void setupGUI() {
        frame.setLayout(new FlowLayout());
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(0, 1));
        frame.add((Component)this.panel, "Center");
        Label label = new Label("Wire - Patch Editor for JSyn");
        this.panel.add(label);
        label.setForeground(Color.blue);
        Font font1 = new Font("Times", 1, 16);
        label.setFont(font1);
        Font font2 = new Font("Times", 0, 14);
        this.panel.setFont(font2);
        this.panel.add(new Label("Version 1.3, build(21)"));
        this.panel.add(new Label("From http://www.softsynth.com/wire/"));
        label = new Label("Full version. Java code export enabled.");
        this.panel.add(label);
        label = new Label("Do NOT redistribute this software.");
        this.panel.add(label);
        label.setForeground(Color.red);
        this.panel.add(new Label("\u00a9 2000-2008 Mobileer Inc, All Rights Reserved"));
        this.panel.validate();
        this.menuBar = new MenuBar();
        this.fileMenu = new Menu("File", true);
        MenuItem exitItem = new MenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wire.this.exit();
            }
        });
        this.fileMenu.add(exitItem);
        this.menuBar.add(this.fileMenu);
        this.viewMenu = new Menu("View", true);
        this.menuItem = new MenuItem("Top Patch");
        this.menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wire.this.topPatch.show();
            }
        });
        this.viewMenu.add(this.menuItem);
        this.menuItem = new MenuItem("Debug Log");
        this.menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextOutput.bringToFront();
            }
        });
        this.viewMenu.add(this.menuItem);
        this.drawStraightItem = new CheckboxMenuItem("Straight Lines", drawStraightLines);
        this.drawStraightItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                drawStraightLines = Wire.this.drawStraightItem.getState();
            }
        });
        this.viewMenu.add(this.drawStraightItem);
        this.menuBar.add(this.viewMenu);
        this.engineMenu = new Menu("Engine", true);
        this.checkItemOff = new CheckboxMenuItem("Off");
        this.checkItemOff.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Wire.this.engineOff();
            }
        });
        this.engineMenu.add(this.checkItemOff);
        this.checkItemOutputOnly = new CheckboxMenuItem("Output Only");
        this.checkItemOutputOnly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Wire.this.engineOutputOnly();
            }
        });
        this.engineMenu.add(this.checkItemOutputOnly);
        this.checkItemInputOnly = new CheckboxMenuItem("Input Only");
        this.checkItemInputOnly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Wire.this.engineInputOnly();
            }
        });
        this.engineMenu.add(this.checkItemInputOnly);
        this.checkItemInputOutput = new CheckboxMenuItem("Input and Output");
        this.checkItemInputOutput.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Wire.this.engineInputOutput();
            }
        });
        this.engineMenu.add(this.checkItemInputOutput);
        this.engineMenu.add(new MenuItem("-"));
        this.checkItem22050 = new CheckboxMenuItem("22050 Hz");
        this.checkItem22050.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Wire.this.engineSetRate(22050.0);
            }
        });
        this.engineMenu.add(this.checkItem22050);
        this.checkItem44100 = new CheckboxMenuItem("44100 Hz");
        this.checkItem44100.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Wire.this.engineSetRate(44100.0);
            }
        });
        this.engineMenu.add(this.checkItem44100);
        this.menuBar.add(this.engineMenu);
        frame.setMenuBar(this.menuBar);
    }

    public boolean isInputEnabled() {
        return this.checkItemInputOnly.getState() || this.checkItemInputOutput.getState();
    }

    public boolean isOutputEnabled() {
        return this.checkItemOutputOnly.getState() || this.checkItemInputOutput.getState();
    }

    void engineSetRate(double rate) {
        if (rate != this.sampleRate) {
            this.sampleRate = rate;
            this.checkItem22050.setState(rate == 22050.0);
            this.checkItem44100.setState(rate == 44100.0);
            if (this.running) {
                if (this.checkItemOutputOnly.getState()) {
                    this.engineOutputOnly();
                } else if (this.checkItemInputOnly.getState()) {
                    this.engineInputOnly();
                } else if (this.checkItemInputOutput.getState()) {
                    this.engineInputOutput();
                }
            }
        }
    }

    void engineOff() {
        if (this.running) {
            Synth.stop();
        }
        this.checkItemOff.setState(true);
        this.checkItemOutputOnly.setState(false);
        this.checkItemInputOnly.setState(false);
        this.checkItemInputOutput.setState(false);
        clock = null;
        this.running = false;
    }

    void engineOutputOnly() {
        if (this.running) {
            Synth.stop();
        }
        this.checkItemOff.setState(false);
        this.checkItemOutputOnly.setState(true);
        this.checkItemInputOnly.setState(false);
        this.checkItemInputOutput.setState(false);
        Synth.start(0, this.sampleRate);
        clock = new SynthClock();
        this.running = true;
    }

    void engineInputOnly() {
        if (this.running) {
            Synth.stop();
        }
        this.checkItemOff.setState(false);
        this.checkItemOutputOnly.setState(false);
        this.checkItemInputOnly.setState(true);
        this.checkItemInputOutput.setState(false);
        Synth.start(96, this.sampleRate);
        clock = new SynthClock();
        this.running = true;
    }

    void engineInputOutput() {
        if (this.running) {
            Synth.stop();
        }
        this.checkItemOff.setState(false);
        this.checkItemOutputOnly.setState(false);
        this.checkItemInputOnly.setState(false);
        this.checkItemInputOutput.setState(true);
        Synth.start(32, this.sampleRate);
        clock = new SynthClock();
        this.running = true;
    }
}

