/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model;

import com.softsynth.util.IndentingWriter;
import com.softsynth.util.TextOutput;
import com.syntona.model.core.PatchModule;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.plugin.SyntonaModule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;

public class SyntonaExporter {
    public static final int PHASE_INIT = 0;
    public static final int PHASE_DECLARE = 1;
    public static final int PHASE_INNER = 2;
    public static final int PHASE_CREATE = 3;
    public static final int PHASE_CONNECT = 4;
    public static final int PHASE_SETUP = 5;
    public static final int PHASE_METHODS = 6;
    public static final int PHASE_NOTE_ON = 7;
    public static final int PHASE_NOTE_OFF = 8;
    public static final int PHASE_COUNT = 9;
    private HashSet<String> uniqueClassNames = new HashSet();
    IndentingWriter writer;

    public boolean export(PatchModulePresenter patchModulePresenter, File file) {
        boolean success = false;
        try {
            if (!file.getName().endsWith(".java")) {
                throw new IOException("File name must end with '.java'");
            }
            FileOutputStream fileStream = new FileOutputStream(file);
            this.writer = new IndentingWriter(fileStream);
            String className = this.extractClassName(file);
            String packageName = this.extractPackageName(file);
            this.generateTopSource(patchModulePresenter.getPatchModule(), className, packageName);
            this.writer.close();
            fileStream.close();
            success = true;
        }
        catch (IOException e) {
            TextOutput.println("Could not write source code file = " + file);
            String message = e.getMessage();
            e.printStackTrace();
            patchModulePresenter.askUserYesNoCancel(message, "ERROR");
        }
        catch (SecurityException e) {
            TextOutput.println("Caught " + e);
            System.exit(1);
        }
        return success;
    }

    public void export(PatchModule patch) {
        String className = patch.getExportedClassName();
        this.generateClass(patch, className);
    }

    public String makeClassNameUnique(String original) {
        int index = 2;
        String candidate = original;
        while (this.uniqueClassNames.contains(candidate)) {
            candidate = String.valueOf(original) + index;
            ++index;
        }
        this.uniqueClassNames.add(candidate);
        return candidate;
    }

    private void generateFileHeader(String packageName) {
        this.writer.setIndentation(0);
        this.writer.println("package " + packageName + ";");
        this.writer.println("import java.io.*;");
        this.writer.println("import com.jsyn.*;");
        this.writer.println("import com.jsyn.unitgen.*;");
        this.writer.println("import com.jsyn.data.*;");
        this.writer.println("import com.jsyn.ports.*;");
        this.writer.println("import com.softsynth.shared.time.TimeStamp;");
        this.writer.println("/**************");
        this.writer.println("** WARNING - this code automatically generated by Syntona.");
        this.writer.println("** The real source is probably a Syntona patch.");
        this.writer.println("** Do NOT edit this file unless you copy it to another directory and change the name.");
        this.writer.println("** Otherwise it is likely to get clobbered the next time you");
        this.writer.println("** export Java source code from Syntona.");
        this.writer.println("**");
        this.writer.println("** Syntona is available from: http://www.softsynth.com/syntona/");
        this.writer.println("*/");
    }

    private void generateTopSource(PatchModule patch, String className, String packageName) throws IOException {
        this.generateFileHeader(packageName);
        this.generateClass(patch, className);
    }

    public void generateClass(PatchModule patch, String className) {
        this.scanModules(patch, 0);
        this.writer.println("public class " + className + " extends Circuit implements UnitVoice");
        this.writer.println("{");
        this.writer.indent();
        this.writer.println("// Declare units and ports.");
        this.scanModules(patch, 1);
        this.writer.println();
        this.writer.println("// Declare inner classes for any child circuits.");
        this.scanModules(patch, 2);
        this.writer.println();
        this.writer.println("public " + className + "()");
        this.writer.println("{");
        this.writer.indent();
        this.writer.println("// Create unit generators.");
        this.scanModules(patch, 3);
        this.writer.println("// Connect units and ports.");
        this.scanModules(patch, 4);
        this.writer.println("// Setup");
        this.scanModules(patch, 5);
        this.writer.undent();
        this.writer.println("}");
        this.scanModules(patch, 6);
        this.writer.println();
        this.writer.println("public void noteOn( double frequency, double amplitude, TimeStamp timeStamp )");
        this.writer.println("{");
        this.writer.indent();
        this.scanModules(patch, 7);
        this.writer.undent();
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public void noteOff( TimeStamp timeStamp )");
        this.writer.println("{");
        this.writer.indent();
        this.scanModules(patch, 8);
        this.writer.undent();
        this.writer.println("}");
        this.writer.println("");
        this.writer.println("public UnitOutputPort getOutput()");
        this.writer.println("{");
        this.writer.indent();
        this.writer.println("return output;");
        this.writer.undent();
        this.writer.println("}");
        this.writer.undent();
        this.writer.println("}");
    }

    private void scanModules(PatchModule patch, int phase) {
        SyntonaModule[] syntonaModuleArray = patch.getModules();
        int n = syntonaModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            SyntonaModule module = syntonaModuleArray[n2];
            module.exportJavaSource(this, phase);
            ++n2;
        }
    }

    String extractRootName(File file) {
        String result = file.getName();
        int iDot = result.indexOf(46);
        if (iDot > 0) {
            result = result.substring(0, iDot);
        }
        return result;
    }

    String extractClassName(File file) {
        String cName = this.extractRootName(file);
        if (Character.isLowerCase(cName.charAt(0))) {
            StringBuffer sbuf = new StringBuffer(cName);
            sbuf.setCharAt(0, (char)(sbuf.charAt(0) - 97 + 65));
            cName = sbuf.toString();
        }
        return cName;
    }

    String extractPackageName(File file) {
        String packageName = "patches";
        String pathName = file.getParent().toLowerCase();
        if (pathName != null) {
            int index = (pathName = pathName.replace(File.separatorChar, '.')).indexOf(".com.");
            if (index >= 0) {
                packageName = pathName.substring(index + 1);
            } else {
                index = pathName.indexOf(".org.");
                if (index >= 0) {
                    packageName = pathName.substring(index + 5);
                } else {
                    index = pathName.indexOf(".jsrc.");
                    if (index >= 0) {
                        packageName = pathName.substring(index + 6);
                    } else {
                        index = pathName.indexOf(".source.");
                        if (index >= 0) {
                            packageName = pathName.substring(index + 8);
                        }
                    }
                }
            }
        }
        return packageName;
    }

    public IndentingWriter getWriter() {
        return this.writer;
    }
}

