/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.plugin.Jack;
import com.syntona.plugin.OutputJack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.SyntonaModule;
import java.util.Iterator;

public abstract class InputJack
extends Jack {
    private boolean kickable;
    private PatchMessage lastMessage;

    public InputJack(SyntonaModule module, String name, String help) {
        super(module, name, help);
    }

    @Override
    public void passMessage(PatchMessage msg) {
        this.lastMessage = msg;
        if (this.isKickable()) {
            this.getModule().kick();
            this.fireChangeListeners();
        }
    }

    public void setKickable(boolean kickable) {
        this.kickable = kickable;
    }

    public boolean isKickable() {
        return this.kickable;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    public boolean detectRecursion(OutputJack other) {
        if (this.isKickable()) {
            Jack[] jacks;
            Jack[] jackArray = jacks = this.getModule().getJacks();
            int n = jacks.length;
            int n2 = 0;
            while (n2 < n) {
                OutputJack outJack;
                Jack jack = jackArray[n2];
                if (jack instanceof OutputJack && !(outJack = (OutputJack)jack).isAsynchronous()) {
                    if (jack == other) {
                        return true;
                    }
                    Iterator<Jack> connected = jack.getConnected();
                    while (connected.hasNext()) {
                        Jack connectedInput = connected.next();
                        if (!((InputJack)connectedInput).detectRecursion(other)) continue;
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public PatchMessage getLastMessage() {
        return this.lastMessage;
    }

    @Override
    public String getValueText() {
        return this.lastMessage == null ? "?" : this.lastMessage.getText();
    }
}

