/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.tools;

import com.syntona.tools.ModificationListener;
import com.syntona.tools.ModificationTracker;
import junit.framework.TestCase;

public class TestHierarchicalModificationTracker
extends TestCase {
    public void testSingle() {
        ModificationTracker tracker = new ModificationTracker();
        TestHierarchicalModificationTracker.assertTrue(!tracker.isDirty());
        tracker.setDirty(true);
        TestHierarchicalModificationTracker.assertTrue(tracker.isDirty());
        tracker.setDirty(false);
        TestHierarchicalModificationTracker.assertTrue(!tracker.isDirty());
        MyModificationListener listener = new MyModificationListener();
        tracker.addModificationListener(listener);
        TestHierarchicalModificationTracker.assertEquals(0, listener.counter);
        tracker.setDirty(true);
        TestHierarchicalModificationTracker.assertEquals(1, listener.counter);
        tracker.setDirty(true);
        TestHierarchicalModificationTracker.assertEquals(1, listener.counter);
        tracker.setDirty(false);
        TestHierarchicalModificationTracker.assertEquals(2, listener.counter);
    }

    public void testNesting() {
        ModificationTracker tracker1 = new ModificationTracker();
        ModificationTracker tracker2 = new ModificationTracker();
        ModificationTracker tracker3 = new ModificationTracker();
        MyModificationListener listener1 = new MyModificationListener();
        MyModificationListener listener2 = new MyModificationListener();
        MyModificationListener listener3 = new MyModificationListener();
        tracker1.addModificationListener(listener1);
        tracker2.addModificationListener(listener2);
        tracker2.addModificationListener(listener3);
    }

    class MyModificationListener
    implements ModificationListener {
        int counter;

        MyModificationListener() {
        }

        @Override
        public void stateChanged(ModificationTracker tracker) {
            ++this.counter;
        }
    }
}

