/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.admin;

import com.transjam.admin.Administrator;
import java.io.IOException;

public class ShutdownThread
extends Thread {
    Administrator admin;
    int seconds;
    int countdown;
    volatile boolean go;

    public ShutdownThread(Administrator admin, int seconds) {
        this.admin = admin;
        this.seconds = seconds;
        this.countdown = seconds;
        this.go = true;
    }

    void broadcast(String text) throws IOException {
        this.admin.broadcast(text);
    }

    void scareClients() throws IOException {
        this.broadcast("Transjam Server shutting down in " + this.countdown + " seconds. Please log out now.");
    }

    @Override
    public void run() {
        try {
            while (this.go && this.countdown > 0) {
                int sleepFor;
                if (this.countdown > 2) {
                    this.scareClients();
                }
                if ((sleepFor = this.countdown > 60 ? 20 : (this.countdown > 20 ? 10 : (this.countdown > 5 ? 5 : this.countdown))) > 0) {
                    try {
                        ShutdownThread.sleep(sleepFor * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.countdown -= sleepFor;
            }
            if (this.go) {
                this.broadcast("Transjam Server shutting down NOW! Goodbye.");
                this.admin.requestShutdown();
            } else {
                this.broadcast("Transjam Server shutdown cancelled. Please continue using the server.");
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public void abort() {
        this.go = false;
        this.interrupt();
    }
}

