/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.awt;

import com.transjam.awt.RoomMenuItem;
import com.transjam.awt.ScheduleDialog;
import com.transjam.awt.StringResources;
import com.transjam.awt.WarningDialog;
import com.transjam.client.Client;
import com.transjam.client.ClientAdapter;
import com.transjam.client.MeetingSchedule;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;

public class LobbyPanel
extends Panel {
    private Frame frame;
    private Client client;
    private ClientAdapter lobbyAdapter;
    private Button newRoomButton;
    private Button showSchedulerButton;
    private Button joinRoomButton;
    private Choice roomChoice;
    private TextField roomNameField;
    private Hashtable rooms;
    private int maxClients;
    private int maxNotFull = 10;
    private String[] suggestedNames = new String[]{"bonkers", "jammers", "clubweb", "area51", "congress", "anthill", "cavern", "herenow"};
    private ScheduleDialog scheduler;

    public LobbyPanel(Frame pFrame, Client pClient, int pMaxClientsPerRoom) {
        this.frame = pFrame;
        this.client = pClient;
        this.maxClients = pMaxClientsPerRoom;
        this.rooms = new Hashtable();
        this.setLayout(new GridLayout(0, 1));
        Panel p1 = new Panel();
        this.add(p1);
        this.newRoomButton = new Button(StringResources.CREATE_NEW_ROOM);
        p1.add(this.newRoomButton);
        this.roomNameField = new TextField(this.suggestedNames[0], 20);
        p1.add(this.roomNameField);
        Panel p2 = new Panel();
        this.add(p2);
        this.roomChoice = new Choice();
        ActionListener newRoomListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String roomName = LobbyPanel.this.roomNameField.getText();
                    if (roomName == null || roomName.length() == 0) {
                        LobbyPanel.this.roomNameField.setText("enter_name");
                    } else {
                        LobbyPanel.this.client.joinNewRoom(LobbyPanel.this.roomNameField.getText(), LobbyPanel.this.maxClients, 0);
                        LobbyPanel.this.setEnabled(false);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        this.newRoomButton.addActionListener(newRoomListener);
        this.roomNameField.addActionListener(newRoomListener);
        this.joinRoomButton = new Button(StringResources.JOIN_EXISTING_ROOM);
        p2.add(this.joinRoomButton);
        this.joinRoomButton.setEnabled(false);
        this.joinRoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String roomName = LobbyPanel.this.roomChoice.getSelectedItem();
                    int commaIndex = roomName.indexOf(40);
                    LobbyPanel.this.client.joinRoom(roomName.substring(0, commaIndex - 1), LobbyPanel.this.maxClients, 0);
                    LobbyPanel.this.setEnabled(false);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        p2.add(this.roomChoice);
        this.add(new Label(String.valueOf(StringResources.ROOM_HELP) + " (" + this.maxClients + ")"));
        this.add(new Label(StringResources.LOOK_AT_SCHEDULE));
        this.add(new Label(StringResources.SCHEDULE_HELP));
        MeetingSchedule schedule = new MeetingSchedule(this.client);
        this.scheduler = new ScheduleDialog(this.frame, schedule);
        this.showSchedulerButton = new Button(StringResources.SHOW_SCHEDULE);
        this.add(this.showSchedulerButton);
        this.showSchedulerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LobbyPanel.this.scheduler.show();
                try {
                    LobbyPanel.this.scheduler.requestMeetingList();
                }
                catch (IOException exc) {
                    System.err.println("Caught exc" + exc);
                }
            }
        });
        this.lobbyAdapter = new ClientAdapter(){

            @Override
            public void enteredRoom(String name, int level) throws IOException {
                LobbyPanel.this.roomChoice.removeAll();
                LobbyPanel.this.rooms.clear();
                LobbyPanel.this.newRoomButton.setEnabled(true);
                LobbyPanel.this.roomNameField.setEnabled(true);
                LobbyPanel.this.joinRoomButton.setEnabled(false);
                LobbyPanel.this.setEnabled(true);
                LobbyPanel.this.client.requestRoomList();
            }

            private void repaintRoomMenu() {
                LobbyPanel.this.roomChoice.invalidate();
                LobbyPanel.this.repaint();
                LobbyPanel.this.getTopParent().validate();
                LobbyPanel.this.getParent().validate();
                LobbyPanel.this.getToolkit().sync();
            }

            @Override
            public void addedRoom(String name, int numClients, int maxClients) {
                RoomMenuItem menuItem = new RoomMenuItem(name, numClients, maxClients);
                LobbyPanel.this.rooms.put(name, menuItem);
                if (numClients < maxClients || maxClients <= 0) {
                    LobbyPanel.this.roomChoice.addItem(menuItem.toString());
                    int numAvail = LobbyPanel.this.roomChoice.getItemCount();
                    if (numAvail == 1) {
                        LobbyPanel.this.joinRoomButton.setEnabled(true);
                    }
                    if (numAvail >= LobbyPanel.this.maxNotFull) {
                        LobbyPanel.this.newRoomButton.setEnabled(false);
                        LobbyPanel.this.roomNameField.setEnabled(false);
                    }
                    this.repaintRoomMenu();
                }
                if (LobbyPanel.this.roomNameField.getText().equals(name)) {
                    LobbyPanel.this.suggestUniqueName();
                }
            }

            @Override
            public void updatedRoom(String name, int numClients, int maxClients) {
                this.deletedRoom(name);
                this.addedRoom(name, numClients, maxClients);
            }

            @Override
            public void deletedRoom(String name) {
                RoomMenuItem menuItem = (RoomMenuItem)LobbyPanel.this.rooms.get(name);
                if (menuItem != null) {
                    LobbyPanel.this.rooms.remove(name);
                    try {
                        LobbyPanel.this.roomChoice.remove(menuItem.toString());
                        int numAvail = LobbyPanel.this.roomChoice.getItemCount();
                        if (numAvail == 0) {
                            LobbyPanel.this.joinRoomButton.setEnabled(false);
                        }
                        if (numAvail < LobbyPanel.this.maxNotFull) {
                            LobbyPanel.this.newRoomButton.setEnabled(true);
                            LobbyPanel.this.roomNameField.setEnabled(true);
                        }
                        this.repaintRoomMenu();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void deniedRoom(String name) {
                WarningDialog dlg = new WarningDialog(LobbyPanel.this.frame, "Request to join denied. Name not unique or room full.", "OK");
                dlg.show();
                LobbyPanel.this.setEnabled(true);
            }
        };
    }

    public void suggestUniqueName() {
        String suggName = "change_me";
        int i = 0;
        while (i < this.suggestedNames.length) {
            String possibleName = this.suggestedNames[i];
            Object obj = this.rooms.get(possibleName);
            if (obj == null) {
                suggName = possibleName;
                break;
            }
            ++i;
        }
        this.roomNameField.setText(suggName);
    }

    public void setMaxNotFull(int max) {
        this.maxNotFull = max;
    }

    public int getMaxNotFull() {
        return this.maxNotFull;
    }

    public void start() {
        this.stop();
        this.client.addMessageListener(this.lobbyAdapter, 1);
    }

    public void stop() {
        this.client.removeMessageListener(this.lobbyAdapter, 1);
    }

    Component getTopParent() {
        Container c;
        LobbyPanel top = c = this;
        while ((c = c.getParent()) != null) {
            top = c;
        }
        return top;
    }
}

