/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.DrumSynth;
import java.awt.Panel;

public class DefaultDrumSynth
implements DrumSynth {
    String[] drumNames = new String[]{"Bass", "Snare", "Zinger"};
    long creationTime = System.currentTimeMillis();

    @Override
    public void init() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void term() {
    }

    @Override
    public int getNumInstruments() {
        return this.drumNames.length;
    }

    @Override
    public String getInstrumentName(int insIndex) {
        return this.drumNames[insIndex];
    }

    @Override
    public int getInstrumentIndex(String insName) {
        int i = 0;
        while (i < this.drumNames.length) {
            if (this.drumNames[i].equals(insName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isTunable(int insIndex) {
        return (insIndex & 1) == 0;
    }

    @Override
    public void hit(double time, double duration, int insIndex, double frequency, double amplitude) {
        System.out.println("Hit at " + time + ", # " + insIndex + ", " + frequency + ", " + amplitude);
    }

    @Override
    public void setPan(int insIndex, double pan) {
    }

    @Override
    public double getTime() {
        long elapsedTime = System.currentTimeMillis() - this.creationTime;
        return (double)elapsedTime * 0.001;
    }

    @Override
    public void sleepUntilTime(double time) throws InterruptedException {
        long wakeupTime = (long)(time * 1000.0) + this.creationTime;
        long sleepFor = wakeupTime - System.currentTimeMillis();
        if (sleepFor > 0L) {
            Thread.sleep(sleepFor);
        }
    }

    @Override
    public Panel getPanel() {
        return null;
    }

    public static void main(String[] args) {
        DefaultDrumSynth synth = new DefaultDrumSynth();
        double time = synth.getTime();
        int i = 0;
        while (i < 10) {
            System.out.println("Time = " + time);
            time += 5.0;
            try {
                synth.sleepUntilTime(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }
}

